/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.renderer;

import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.entity.PostcardEntity;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.helper.ColorHelper;
import com.flechazo.contact.resourse.PostcardStyle;
import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class PostcardEntityRenderer<T extends PostcardEntity>
extends class_897<T> {
    private static final class_1091 PIN = new class_1091("contact", "postcard_pin", "");
    private static final class_1091 POSTCARD = new class_1091("contact", "postcard", "");
    private final class_776 blockRenderDispatcher;
    private final List<String> list = Lists.newArrayList();
    private int textHash = 0;

    public PostcardEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.blockRenderDispatcher = ctx.method_43337();
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 poseStack, class_4597 multiBufferSource, int light) {
        super.method_3936(entity, yaw, tickDelta, poseStack, multiBufferSource, light);
        poseStack.method_22903();
        class_2350 direction = entity.method_5735();
        class_243 vec3d = this.getRenderOffset(entity, tickDelta);
        poseStack.method_22904(-vec3d.method_10216(), -vec3d.method_10214(), -vec3d.method_10215());
        double d = 0.46875;
        poseStack.method_22904((double)direction.method_10148() * d, (double)direction.method_10164() * d, (double)direction.method_10165() * d);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        boolean bl = entity.method_5767();
        class_1799 postcard = ((PostcardEntity)((Object)entity)).getPostcard();
        if (!postcard.method_7960()) {
            String text;
            PostcardStyle postcardStyle = PostcardStyle.fromNBT(postcard.method_7948());
            float width = (float)postcardStyle.cardWidth() / 2.0f;
            float height = (float)postcardStyle.cardHeight() / 2.0f;
            int j = ((PostcardEntity)((Object)entity)).getRotation();
            if (direction.method_10146() > 1) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)((j + 1) % 3 - 1) * 360.0f / 16.0f));
            } else {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)j * 360.0f / 16.0f));
            }
            class_1092 modelManager = this.blockRenderDispatcher.method_3351().method_3333();
            if (!bl && direction.method_10146() > 1) {
                float red = ColorHelper.getRedF(postcardStyle.postmarkColor());
                float green = ColorHelper.getGreenF(postcardStyle.postmarkColor());
                float blue = ColorHelper.getBlueF(postcardStyle.postmarkColor());
                poseStack.method_22903();
                poseStack.method_46416(-0.5f, -0.5f, -0.5f);
                poseStack.method_46416(0.0f, -(128.0f - height) / 256.0f, 0.0f);
                this.blockRenderDispatcher.method_3350().method_3367(poseStack.method_23760(), multiBufferSource.getBuffer(class_4722.method_24073()), null, modelManager.method_4742(PIN), red, green, blue, light, class_4608.field_21444);
                poseStack.method_22909();
            }
            poseStack.method_22903();
            poseStack.method_22905(width / 128.0f, height / 128.0f, 1.0f);
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            this.blockRenderDispatcher.method_3350().method_3367(poseStack.method_23760(), multiBufferSource.getBuffer(class_4722.method_24073()), null, modelManager.method_4742(POSTCARD), 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
            poseStack.method_22909();
            poseStack.method_46416(0.0f, 0.0f, 0.5f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            poseStack.method_22905(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.method_46416(-64.0f, -64.0f, 0.0f);
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            class_4588 vertexConsumer = multiBufferSource.getBuffer(ClientProxy.getPostcardCardRenderLayer(postcardStyle));
            float pointX0 = 64.0f - width / 2.0f;
            float pointX1 = 64.0f + width / 2.0f;
            float pointY0 = 64.0f - height / 2.0f;
            float pointY1 = 64.0f + height / 2.0f;
            vertexConsumer.method_22918(matrix4f, pointX0, pointY1, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
            vertexConsumer.method_22918(matrix4f, pointX1, pointY1, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
            vertexConsumer.method_22918(matrix4f, pointX1, pointY0, -0.01f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
            vertexConsumer.method_22918(matrix4f, pointX0, pointY0, -0.01f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
            if (postcard.method_7948().method_10545("Sender")) {
                float markX0 = pointX0 + (float)postcardStyle.postmarkPosX() / 2.0f;
                float markY0 = pointY0 + (float)postcardStyle.postmarkPosY() / 2.0f;
                class_4588 vertex = multiBufferSource.getBuffer(ClientProxy.getPostcardPostmarkRenderLayer(postcardStyle));
                float markWidth = (float)postcardStyle.postmarkWidth() / 2.0f;
                float markHeight = (float)postcardStyle.postmarkHeight() / 2.0f;
                int red = ColorHelper.getRed(postcardStyle.postmarkColor());
                int green = ColorHelper.getGreen(postcardStyle.postmarkColor());
                int blue = ColorHelper.getBlue(postcardStyle.postmarkColor());
                int alpha = ColorHelper.getAlpha(postcardStyle.postmarkColor());
                vertex.method_22918(matrix4f, markX0, markY0 + markHeight, -0.02f).method_1336(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
                vertex.method_22918(matrix4f, markX0 + markWidth, markY0 + markHeight, -0.02f).method_1336(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
                vertex.method_22918(matrix4f, markX0 + markWidth, markY0, -0.02f).method_1336(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
                vertex.method_22918(matrix4f, markX0, markY0, -0.02f).method_1336(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
            }
            if (!(text = PostcardItem.getText(postcard)).isBlank()) {
                class_327 font = class_310.method_1551().field_1772;
                float textX0 = pointX0 + (float)postcardStyle.textPosX() / 2.0f;
                float textY0 = pointY0 + (float)postcardStyle.textPosY() / 2.0f;
                if (this.textHash != text.hashCode()) {
                    this.list.clear();
                    font.method_27527().method_27485(text, postcardStyle.textWidth(), class_2583.field_24360, true, (style, lineStartPos, lineEndPos) -> {
                        String lineTextRaw = text.substring(lineStartPos, lineEndPos);
                        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
                        this.list.add(lineText);
                    });
                    this.textHash = text.hashCode();
                }
                poseStack.method_22903();
                poseStack.method_46416(textX0, textY0, -0.025f);
                poseStack.method_22905(0.5f, 0.5f, 1.0f);
                poseStack.method_46416(0.0f, 0.0f, -0.1f);
                for (String t : this.list) {
                    font.method_27521(t, 0.0f, 0.0f, postcardStyle.textColor(), false, poseStack.method_23760().method_23761(), multiBufferSource, class_327.class_6415.field_33993, 0, light);
                    poseStack.method_46416(0.0f, 12.0f, 0.0f);
                }
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public class_2960 getTextureLocation(T entity) {
        return class_1059.field_5275;
    }

    public class_243 getRenderOffset(T entity, float f) {
        return new class_243((double)((float)entity.method_5735().method_10148() * 0.3f), -0.25, (double)((float)entity.method_5735().method_10165() * 0.3f));
    }

    protected boolean shouldShowName(T entity) {
        if (!class_310.method_1498() || ((PostcardEntity)((Object)entity)).getPostcard().method_7960() || !((PostcardEntity)((Object)entity)).getPostcard().method_7938() || this.field_4676.field_4678 != entity) {
            return false;
        }
        double d = this.field_4676.method_23168(entity);
        float f = entity.method_21751() ? 32.0f : 64.0f;
        return d < (double)(f * f);
    }
}

