/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.widget;

import com.flechazo.contact.network.PostcardEditMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3728;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class EditableTextBox
extends class_339 {
    private final class_310 mc = class_310.method_1551();
    private final class_327 font;
    private boolean isModified = false;
    private int updateCount = 0;
    private long lastClickTime = 0L;
    private final int color;
    private final int spacing;
    private final class_3728 textInputUtil;
    @Nullable
    private Page currentPage = null;
    private String page = "";
    private final class_1799 item;
    private final class_1657 editingPlayer;
    private final class_1268 hand;

    public EditableTextBox(class_1799 item, class_1657 playerIn, class_1268 handIn, int x, int y, int boxWidth, int boxHeight, int spacingPixel, int color, class_2561 title) {
        super(x, y, boxWidth, boxHeight, title);
        class_2520 tag;
        this.font = this.mc.field_1772;
        this.color = color;
        this.spacing = spacingPixel;
        this.item = item;
        this.editingPlayer = playerIn;
        this.hand = handIn;
        class_2487 compoundnbt = item.method_7969();
        if (compoundnbt != null && (tag = compoundnbt.method_10580("Text")) != null) {
            this.page = tag.method_10707().method_10714();
        }
        this.textInputUtil = new class_3728(() -> this.page, this::setText, this::getClipboardText, this::setClipboardText, text -> {
            if (text.length() >= 1024) return false;
            int n = this.font.method_1713(text, boxWidth);
            Objects.requireNonNull(this.font);
            if (n > boxHeight * 9 / spacingPixel) return false;
            return true;
        });
    }

    public void tick() {
        ++this.updateCount;
    }

    public void sendTextToServer() {
        if (this.isModified) {
            this.item.method_7948().method_10566("Text", (class_2520)class_2519.method_23256((String)this.page));
            int i = this.hand == class_1268.field_5808 ? this.editingPlayer.method_31548().field_7545 : 40;
            PostcardEditMessage packet = PostcardEditMessage.create(this.item, i);
            packet.sendToServer();
        }
    }

    private Page createPage() {
        Point point;
        boolean flag;
        if (this.page.isEmpty()) {
            return Page.EMPTY;
        }
        int selectionStart = this.textInputUtil.method_16201();
        int selectionEnd = this.textInputUtil.method_16203();
        IntArrayList intlist = new IntArrayList();
        ArrayList lines = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        class_5225 stringSplitter = this.font.method_27527();
        stringSplitter.method_27485(this.page, this.field_22758, class_2583.field_24360, true, (arg_0, arg_1, arg_2) -> this.lambda$createPage$2(mutableint, mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] linesStartPos = intlist.toIntArray();
        boolean bl = flag = selectionStart == this.page.length();
        if (flag && mutableboolean.isTrue()) {
            point = new Point(0, lines.size() * this.spacing);
        } else {
            int line = EditableTextBox.getCursorLine(linesStartPos, selectionStart);
            point = new Point(this.font.method_1727(this.page.substring(linesStartPos[line], selectionStart)), line * this.spacing);
        }
        ArrayList rectangleList = Lists.newArrayList();
        if (selectionStart != selectionEnd) {
            int selectionEndLine;
            int selectionMin = Math.min(selectionStart, selectionEnd);
            int selectionMax = Math.max(selectionStart, selectionEnd);
            int selectionStartLine = EditableTextBox.getCursorLine(linesStartPos, selectionMin);
            if (selectionStartLine == (selectionEndLine = EditableTextBox.getCursorLine(linesStartPos, selectionMax))) {
                int linePosY = selectionStartLine * this.spacing;
                int linePosX = linesStartPos[selectionStartLine];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, selectionMax, linePosY, linePosX));
            } else {
                int i3 = selectionStartLine + 1 > linesStartPos.length ? this.page.length() : linesStartPos[selectionStartLine + 1];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, i3, selectionStartLine * this.spacing, linesStartPos[selectionStartLine]));
                for (int j3 = selectionStartLine + 1; j3 < selectionEndLine; ++j3) {
                    int j2 = j3 * this.spacing;
                    String s1 = this.page.substring(linesStartPos[j3], linesStartPos[j3 + 1]);
                    int k2 = (int)stringSplitter.method_27482(s1);
                    rectangleList.add(this.getRectangle(new Point(0, j2), new Point(k2, j2 + 9)));
                }
                rectangleList.add(this.getRectangle(this.page, stringSplitter, linesStartPos[selectionEndLine], selectionMax, selectionEndLine * this.spacing, linesStartPos[selectionEndLine]));
            }
        }
        return new Page(this.page, point, flag, linesStartPos, lines.toArray(new Line[0]), rectangleList.toArray(new class_768[0]));
    }

    private class_768 getRectangle(String text, class_5225 characterManager, int from, int to, int lineStart, int lineEnd) {
        String s = text.substring(lineEnd, from);
        String s1 = text.substring(lineEnd, to);
        Point pointFrom = new Point((int)characterManager.method_27482(s), lineStart);
        Point pointTo = new Point((int)characterManager.method_27482(s1), lineStart + this.spacing);
        return this.getRectangle(pointFrom, pointTo);
    }

    private class_768 getRectangle(Point pointFromIn, Point pointToIn) {
        Point pointFrom = this.getPointPosInScreen(pointFromIn);
        Point pointTo = this.getPointPosInScreen(pointToIn);
        int i = Math.min(pointFrom.x, pointTo.x);
        int j = Math.max(pointFrom.x, pointTo.x);
        int k = Math.min(pointFrom.y, pointTo.y);
        int l = Math.max(pointFrom.y, pointTo.y);
        return new class_768(i, k, j - i, l - k);
    }

    private Page getPage() {
        if (this.currentPage == null) {
            this.currentPage = this.createPage();
        }
        return this.currentPage;
    }

    private void setText(String text) {
        this.page = text;
        this.isModified = true;
    }

    private String getClipboardText() {
        return this.mc != null ? class_3728.method_27556((class_310)this.mc) : "";
    }

    private void setClipboardText(String text) {
        if (this.mc != null) {
            class_3728.method_27551((class_310)this.mc, (String)text);
        }
    }

    public void shouldRefresh() {
        this.currentPage = null;
    }

    private void getDownLine() {
        this.toMoveCursorLine(1);
    }

    private void getUpLine() {
        this.toMoveCursorLine(-1);
    }

    private void toMoveCursorLine(int lineAdded) {
        int i = this.textInputUtil.method_16201();
        int j = this.getPage().getLineToMove(i, lineAdded);
        this.textInputUtil.method_27560(j, class_437.method_25442());
    }

    private static int getCursorLine(int[] linesLength, int cursorPos) {
        int i = Arrays.binarySearch(linesLength, cursorPos);
        return i < 0 ? -(i + 2) : i;
    }

    private void moveToLineHead() {
        if (class_437.method_25441()) {
            this.textInputUtil.method_27553(class_437.method_25442());
        } else {
            int i = this.textInputUtil.method_16201();
            int j = this.getPage().getLineStartPos(i);
            this.textInputUtil.method_27560(j, class_437.method_25442());
        }
    }

    private void moveToLineEnd() {
        if (class_437.method_25441()) {
            this.textInputUtil.method_27558(class_437.method_25442());
        } else {
            int i = this.textInputUtil.method_16201();
            int j = this.getPage().getLineEndPos(i);
            this.textInputUtil.method_27560(j, class_437.method_25442());
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean flag = this.keyPressedInBook(keyCode, scanCode, modifiers);
        if (flag) {
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    private boolean keyPressedInBook(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25439((int)keyCode)) {
            this.textInputUtil.method_27563();
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            this.textInputUtil.method_27559();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.textInputUtil.method_27554();
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            this.textInputUtil.method_27547();
            return true;
        }
        class_3728.class_7279 cursorStep = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        return switch (keyCode) {
            case 257, 335 -> {
                this.textInputUtil.method_16197("\n");
                yield true;
            }
            case 259 -> {
                this.textInputUtil.method_42574(-1, cursorStep);
                yield true;
            }
            case 261 -> {
                this.textInputUtil.method_42574(1, cursorStep);
                yield true;
            }
            case 262 -> {
                this.textInputUtil.method_42575(1, class_437.method_25442(), cursorStep);
                yield true;
            }
            case 263 -> {
                this.textInputUtil.method_42575(-1, class_437.method_25442(), cursorStep);
                yield true;
            }
            case 264 -> {
                this.getDownLine();
                yield true;
            }
            case 265 -> {
                this.getUpLine();
                yield true;
            }
            case 268 -> {
                this.moveToLineHead();
                yield true;
            }
            case 269 -> {
                this.moveToLineEnd();
                yield true;
            }
            default -> false;
        };
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (super.method_25400(codePoint, modifiers)) {
            return true;
        }
        if (class_155.method_643((char)codePoint)) {
            this.textInputUtil.method_16197(Character.toString(codePoint));
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Page page = this.getPage();
        for (Line line : page.lines) {
            guiGraphics.method_51439(this.font, line.lineTextComponent, line.x, line.y, this.color, false);
        }
        this.renderSelection(page.selection);
        this.renderCursor(guiGraphics, page.point, page.isInsert);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    private void renderSelection(class_768[] selection) {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (class_768 rectangle2d : selection) {
            int i = rectangle2d.method_3321();
            int j = rectangle2d.method_3322();
            int k = i + rectangle2d.method_3319();
            int l = j + rectangle2d.method_3320();
            bufferbuilder.method_22912((double)i, (double)l, 0.0).method_1344();
            bufferbuilder.method_22912((double)k, (double)l, 0.0).method_1344();
            bufferbuilder.method_22912((double)k, (double)j, 0.0).method_1344();
            bufferbuilder.method_22912((double)i, (double)j, 0.0).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.disableColorLogicOp();
    }

    private void renderCursor(class_332 guiGraphics, Point point, boolean isInsert) {
        if (this.updateCount / 6 % 2 == 0 && this.field_22759 != 0) {
            point = this.getPointPosInScreen(point);
            if (!isInsert) {
                guiGraphics.method_25294(point.x, point.y - 1, point.x + 1, point.y + 9, this.color);
            } else {
                guiGraphics.method_51433(this.font, "_", point.x, point.y, this.color, false);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            long i = class_156.method_658();
            int j = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            if (j >= 0) {
                if (i - this.lastClickTime < 250L) {
                    if (!this.textInputUtil.method_27568()) {
                        this.setSelectionRange(j);
                    } else {
                        this.textInputUtil.method_27563();
                    }
                } else {
                    this.textInputUtil.method_27560(j, class_437.method_25442());
                }
                this.shouldRefresh();
            }
            this.lastClickTime = i;
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            int i = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            this.textInputUtil.method_27560(i, true);
            this.shouldRefresh();
        }
        return true;
    }

    protected void method_47399(class_6382 output) {
    }

    private void setSelectionRange(int cursorPos) {
        this.textInputUtil.method_27548(class_5225.method_27483((String)this.page, (int)-1, (int)cursorPos, (boolean)false), class_5225.method_27483((String)this.page, (int)1, (int)cursorPos, (boolean)false));
    }

    private Point getPointPosInBox(Point pointIn) {
        return new Point(pointIn.x - this.method_46426(), pointIn.y - this.method_46427());
    }

    private Point getPointPosInScreen(Point pointIn) {
        return new Point(pointIn.x + this.method_46426(), pointIn.y + this.method_46427());
    }

    private /* synthetic */ void lambda$createPage$2(MutableInt mutableint, MutableBoolean mutableboolean, IntList intlist, List lines, class_2583 style, int lineStartPos, int lineEndPos) {
        int lineCount = mutableint.getAndIncrement();
        String lineTextRaw = this.page.substring(lineStartPos, lineEndPos);
        mutableboolean.setValue(lineTextRaw.endsWith("\n"));
        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
        int y = lineCount * this.spacing;
        Point point = this.getPointPosInScreen(new Point(0, y));
        intlist.add(lineStartPos);
        lines.add(new Line(style, lineText, point.x, point.y));
    }

    static class Page {
        protected static final Page EMPTY = new Page("", new Point(0, 0), true, new int[]{0}, new Line[]{new Line(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        private final String text;
        private final Point point;
        private final boolean isInsert;
        private final int[] linesStartPos;
        protected final Line[] lines;
        private final class_768[] selection;

        public Page(String text, Point point, boolean isInsert, int[] linesStartPos, Line[] lines, class_768[] selection) {
            this.text = text;
            this.point = point;
            this.isInsert = isInsert;
            this.linesStartPos = linesStartPos;
            this.lines = lines;
            this.selection = selection;
        }

        public int getMousePointPosInText(class_327 font, Point point, int spacingPixel) {
            int linePos = point.y / spacingPixel;
            if (linePos < 0) {
                return 0;
            }
            if (linePos >= this.lines.length) {
                return this.text.length();
            }
            Line line = this.lines[linePos];
            return this.linesStartPos[linePos] + font.method_27527().method_27484(line.lineText, point.x, line.style);
        }

        public int getLineToMove(int cursorPos, int lineAdded) {
            int k;
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            int j = i + lineAdded;
            if (0 <= j && j < this.linesStartPos.length) {
                int l = cursorPos - this.linesStartPos[i];
                int i1 = this.lines[j].lineText.length();
                k = this.linesStartPos[j] + Math.min(l, i1);
            } else {
                k = cursorPos;
            }
            return k;
        }

        public int getLineStartPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i];
        }

        public int getLineEndPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i] + this.lines[i].lineText.length();
        }
    }

    record Point(int x, int y) {
    }

    static class Line {
        private final class_2583 style;
        private final String lineText;
        protected final class_2561 lineTextComponent;
        protected final int x;
        protected final int y;

        public Line(class_2583 style, String text, int x, int y) {
            this.style = style;
            this.lineText = text;
            this.x = x;
            this.y = y;
            this.lineTextComponent = class_2561.method_43470((String)text).method_10862(style);
        }
    }
}

