/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.DoubleHorizontalBlock;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.helper.VoxelShapeHelper;
import com.flechazo.contact.platform.PlatformHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends DoubleHorizontalBlock
implements class_2343,
ISilveroakEntry {
    public static final class_2746 OPEN = class_2741.field_12537;
    public final class_1767 boxColor;
    public final class_1767 flagColor;
    public static final class_265 LOWER_SHAPE = VoxelShapeHelper.createVoxelShape(7.0, 0.0, 7.0, 2.0, 16.0, 2.0);
    public static final class_265 UPPER_SHAPE_NORTH = VoxelShapeHelper.createVoxelShape(3.0, 0.0, 1.0, 10.0, 9.0, 14.0);
    public static final class_265 UPPER_SHAPE_EAST = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 3.0, 14.0, 9.0, 10.0);

    public MailboxBlock(class_1767 boxColor, class_1767 flagColor) {
        super(class_4970.class_2251.method_9637().method_51517(boxColor).method_22488().method_9626(class_2498.field_11544).method_9629(1.5f, 6.0f));
        this.boxColor = boxColor;
        this.flagColor = flagColor;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public MailboxBlock(class_1767 boxColor) {
        this(boxColor, class_1767.field_7964);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (((class_2756)state.method_11654((class_2769)HALF)).equals((Object)class_2756.field_12607)) {
            return this.getLowerShape();
        }
        return switch ((class_2350)state.method_11654((class_2769)field_11177)) {
            case class_2350.field_11034, class_2350.field_11039 -> UPPER_SHAPE_EAST;
            default -> UPPER_SHAPE_NORTH;
        };
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPEN});
    }

    @Override
    protected class_265 getLowerShape() {
        return LOWER_SHAPE;
    }

    @Override
    protected class_265 getUpperShape() {
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (!level.field_9236) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            class_2338 topPos = state.method_11654((class_2769)HALF) == class_2756.field_12609 ? pos : pos.method_10084();
            UUID mailboxOwner = data.getMailboxOwner((class_5321<class_1937>)level.method_27983(), topPos);
            if (player.method_5715() && mailboxOwner == null) {
                if (data.getMailboxPos(player.method_5667()) == null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.binding"), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.switch"), true);
                }
                data.setMailboxData(player.method_5667(), (class_5321<class_1937>)level.method_27983(), topPos);
                MailboxManager.updateState(level, topPos);
                AdvancementManager.givePlayerAdvancement(level.method_8503(), (class_3222)player, new class_2960("contact:root"));
                return class_1269.field_5812;
            }
            if (Objects.equals(mailboxOwner, player.method_5667())) {
                class_1277 contents = data.getMailboxContents(mailboxOwner);
                boolean isEmpty = true;
                for (int i = 0; i < contents.method_5439(); ++i) {
                    class_1799 parcel = contents.method_5438(i);
                    if (parcel.method_7960()) continue;
                    if (parcel.method_7909() instanceof PostcardItem) {
                        AdvancementManager.givePlayerAdvancement(level.method_8503(), (class_3222)player, new class_2960("contact:receive_postcard"));
                    }
                    if (parcel.method_7948().method_10545("AnotherWorld")) {
                        AdvancementManager.givePlayerAdvancement(level.method_8503(), (class_3222)player, new class_2960("contact:from_another_world"));
                    }
                    player.method_31548().method_7398(parcel);
                    isEmpty = false;
                }
                data.resetMailboxContents(mailboxOwner);
                if (!isEmpty) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.pick_up"), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.empty"), true);
                }
                MailboxManager.updateState(level, topPos);
                return class_1269.field_5812;
            }
            if (player.method_5998(handIn).method_7909() instanceof IMailItem) {
                if (mailboxOwner != null) {
                    class_1799 held = player.method_5998(handIn).method_7972();
                    if (!held.method_7948().method_10545("Sender")) {
                        if (!data.isMailboxFull(mailboxOwner)) {
                            MailboxBlockEntity mailbox;
                            class_2586 class_25862 = level.method_8321(topPos);
                            if (class_25862 instanceof MailboxBlockEntity && (mailbox = (MailboxBlockEntity)class_25862).checkToSend()) {
                                held.method_7948().method_10582("Sender", player.method_5477().getString());
                                data.addMailboxContents(mailboxOwner, held);
                                player.method_6122(handIn, class_1799.field_8037);
                                player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.deliver"), true);
                                AdvancementManager.givePlayerAdvancement(player.method_5682(), (class_3222)player, new class_2960("contact:send_in_person"));
                                MailboxManager.updateState(level, topPos);
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.check"), true);
                            }
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.full"), true);
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.used"), true);
                    }
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.no_owner"), true);
                return class_1269.field_5812;
            }
            if (mailboxOwner != null) {
                PlatformHelper.getCurrentServer().method_3793().method_14512(mailboxOwner).ifPresent(gameProfile -> player.method_7353((class_2561)class_2561.method_43469((String)"message.contact.mailbox.others", (Object[])new Object[]{gameProfile.getName()}), true));
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.no_owner_tips"), true);
            return class_1269.field_5814;
        }
        return class_1269.field_5812;
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(level, pos, state, player);
        if (!level.field_9236) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            class_2338 topPos = state.method_11654((class_2769)HALF) == class_2756.field_12609 ? pos : pos.method_10084();
            data.removeMailboxData(class_4208.method_19443((class_5321)level.method_27983(), (class_2338)topPos));
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return MailboxBlock.createTickerHelper(type, MailboxBlockEntity::tick);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> blockEntityType, class_5558<? super E> entityTicker) {
        return BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get() == blockEntityType ? entityTicker : null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((class_2591)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get()).method_11032(pos, state);
    }

    @Override
    public class_2960 getRegistryID() {
        return Contact.getRL(this.boxColor.method_7792() + "_mailbox");
    }
}

