/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.command;

import com.flechazo.contact.common.command.arguments.PostcardStyleArgument;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.ParcelItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.platform.PlatformHelper;
import com.flechazo.contact.resourse.PostcardDataManager;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class ContactCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_PLAYERS = (context, builder) -> {
        MinecraftServer server = PlatformHelper.getCurrentServer();
        HashSet set = Sets.newHashSet();
        if (server != null) {
            IMailboxDataProvider data = MailboxDataManager.getData(server);
            set.addAll(data.getNameToUUID().keySet());
        }
        set.add("\"@e\"");
        return class_2172.method_9265((Iterable)set, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> SUGGEST_POSTCARDS = (context, builder) -> {
        Set<class_2960> collection = PostcardDataManager.getPostcards().keySet();
        return class_2172.method_9270(collection, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"contact").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"postcard").then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"postcard", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POSTCARDS).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).executes(context -> ContactCommand.givePostcard((class_2168)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<class_2168>)context, "postcard"), class_2186.method_9312((CommandContext)context, (String)"targets"), "", BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"sender", (ArgumentType)StringArgumentType.string()).executes(context -> ContactCommand.givePostcard((class_2168)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<class_2168>)context, "postcard"), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))).then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.givePostcard((class_2168)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<class_2168>)context, "postcard"), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))).then(class_2170.method_9247((String)"deliver").then(class_2170.method_9244((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(class_2170.method_9244((String)"postcard", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POSTCARDS).then(class_2170.method_9244((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"sender", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).executes(context -> ContactCommand.deliverPostcard((class_2168)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<class_2168>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.deliverPostcard((class_2168)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<class_2168>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"parcel").then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"sender", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"item1", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(class_2170.method_9244((String)"item2", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(class_2170.method_9244((String)"item3", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), class_2287.method_9777((CommandContext)context, (String)"item3").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(class_2170.method_9244((String)"item4", (ArgumentType)class_2287.method_9776((class_7157)access)).then(class_2170.method_9244((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), class_2287.method_9777((CommandContext)context, (String)"item3").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), class_2287.method_9777((CommandContext)context, (String)"item4").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false)))))))))))))))).then(class_2170.method_9247((String)"deliver").then(class_2170.method_9244((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(class_2170.method_9244((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"sender", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).then(class_2170.method_9244((String)"item1", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(class_2170.method_9244((String)"item2", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(class_2170.method_9244((String)"item3", (ArgumentType)class_2287.method_9776((class_7157)access)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), class_2287.method_9777((CommandContext)context, (String)"item3").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(class_2170.method_9244((String)"item4", (ArgumentType)class_2287.method_9776((class_7157)access)).then(class_2170.method_9244((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), class_2287.method_9777((CommandContext)context, (String)"item1").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), class_2287.method_9777((CommandContext)context, (String)"item2").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), class_2287.method_9777((CommandContext)context, (String)"item3").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), class_2287.method_9777((CommandContext)context, (String)"item4").method_9781(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false))))))))))))))))));
    }

    private static void deliverToPlayerMailbox(class_2168 source, String target, int ticks, AtomicInteger n, class_1799 parcel) {
        IMailboxDataProvider data = MailboxDataManager.getData(source.method_9211());
        UUID uuid = data.getNameToUUID().get(target);
        if (uuid != null) {
            if (!data.isMailboxFull(uuid)) {
                data.getMailList().add(new MailToBeSent(uuid, parcel, ticks));
                n.getAndIncrement();
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"command.contact.deliver.full", (Object[])new Object[]{target}), true);
            }
        }
    }

    private static int deliverParcel(class_2168 source, String target, int ticks, String sender, boolean isEnder, class_1799 ... list) {
        AtomicInteger n = new AtomicInteger(0);
        class_1277 contents = new class_1277(4);
        for (int i = 0; i < list.length; ++i) {
            contents.method_5447(i, list[i]);
        }
        class_1799 parcel = ParcelItem.getParcel(contents, isEnder, sender);
        if (target.equals("@e")) {
            IMailboxDataProvider data = MailboxDataManager.getData(source.method_9211());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, parcel));
        } else {
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, parcel);
        }
        if (n.get() == 1 && target.equals("@e")) {
            source.method_9226(() -> class_2561.method_43469((String)"command.contact.deliver.success.single", (Object[])new Object[]{new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_PARCEL.get() : (class_1935)ItemRegistry.PARCEL.get()).method_7964(), target}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_PARCEL.get() : (class_1935)ItemRegistry.PARCEL.get()).method_7964(), n.get()}), true);
        }
        return n.get();
    }

    private static int giveParcel(class_2168 source, Collection<class_3222> targets, String sender, boolean isEnder, class_1799 ... list) {
        class_1277 contents = new class_1277(4);
        for (int i = 0; i < list.length; ++i) {
            contents.method_5447(i, list[i]);
        }
        class_1799 parcel = ParcelItem.getParcel(contents, isEnder, sender);
        ContactCommand.giveParcelToPlayers(targets, parcel);
        if (targets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{1, new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_PARCEL.get() : (class_1935)ItemRegistry.PARCEL.get()).method_7964(), ((class_3222)targets.iterator().next()).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{1, new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_PARCEL.get() : (class_1935)ItemRegistry.PARCEL.get()).method_7964(), targets.size()}), true);
        }
        return targets.size();
    }

    private static int deliverPostcard(class_2168 source, class_2960 id, String target, int ticks, String sender, boolean isEnder, String text) {
        text = text.replace("\\n", "\n");
        AtomicInteger n = new AtomicInteger(0);
        if (target.equals("@e")) {
            class_1799 postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.method_7948().method_10582("Sender", sender);
            IMailboxDataProvider data = MailboxDataManager.getData(source.method_9211());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, postcard));
        } else {
            class_1799 postcard = PostcardItem.setText(PostcardItem.getPostcard(id, false), text);
            postcard.method_7948().method_10582("Sender", sender);
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, postcard);
        }
        if (n.get() == 1 && !target.equals("@e")) {
            source.method_9226(() -> class_2561.method_43469((String)"command.contact.deliver.success.single", (Object[])new Object[]{new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_POSTCARD.get() : (class_1935)ItemRegistry.POSTCARD.get()).method_7964(), target}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new class_1799(isEnder ? (class_1935)ItemRegistry.ENDER_POSTCARD.get() : (class_1935)ItemRegistry.POSTCARD.get()).method_7964(), n.get()}), true);
        }
        return n.get();
    }

    private static int givePostcard(class_2168 source, class_2960 id, Collection<class_3222> targets, String sender, boolean isEnder, String text) {
        class_1799 postcard;
        text = text.replace("\\n", "\n");
        if (sender.isEmpty()) {
            postcard = PostcardItem.getPostcard(id, isEnder);
        } else {
            postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.method_7948().method_10582("Sender", sender);
        }
        ContactCommand.giveParcelToPlayers(targets, postcard);
        if (targets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{1, new class_1799((class_1935)ItemRegistry.POSTCARD.get()).method_7964(), ((class_3222)targets.iterator().next()).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.give.success.single", (Object[])new Object[]{1, new class_1799((class_1935)ItemRegistry.POSTCARD.get()).method_7964(), targets.size()}), true);
        }
        return targets.size();
    }

    private static void giveParcelToPlayers(Collection<class_3222> targets, class_1799 parcel) {
        for (class_3222 serverPlayer : targets) {
            boolean flag = serverPlayer.method_31548().method_7394(parcel);
            if (flag) {
                class_1542 itemEntity = serverPlayer.method_7328(parcel, false);
                if (itemEntity != null) {
                    itemEntity.method_6987();
                }
                serverPlayer.method_37908().method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverPlayer.method_6051().method_43057() - serverPlayer.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.field_7498.method_7623();
                continue;
            }
            class_1542 itementity = serverPlayer.method_7328(parcel, false);
            if (itementity == null) continue;
            itementity.method_6975();
            itementity.method_6981(serverPlayer.method_5667());
        }
    }
}

