/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.storage;

import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.network.ActionMessage;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerMailboxData {
    public final Map<String, UUID> nameToUUID = Maps.newTreeMap();
    public final Map<UUID, class_1277> uuidToContents = Maps.newHashMap();
    private final Map<UUID, class_4208> uuidToLocation = Maps.newHashMap();
    private final Map<class_4208, UUID> locationToPlayer = Maps.newHashMap();
    public final List<MailToBeSent> mailList = Lists.newArrayList();

    public class_1277 getMailboxContents(UUID uuid) {
        return this.uuidToContents.getOrDefault(uuid, new class_1277(24));
    }

    public boolean isMailboxEmpty(UUID uuid) {
        class_1277 contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return true;
        }
        for (int i = 0; i < contents.method_5439(); ++i) {
            if (contents.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isMailboxFull(UUID uuid) {
        class_1277 contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return false;
        }
        for (int i = 0; i < contents.method_5439(); ++i) {
            if (!contents.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean addMailboxContents(UUID uuid, class_1799 parcelIn) {
        class_1277 mailbox = this.getMailboxContents(uuid);
        if (!this.isMailboxFull(uuid)) {
            for (int i = 0; i < mailbox.method_5439(); ++i) {
                if (!mailbox.method_5438(i).method_7960()) continue;
                mailbox.method_5447(i, parcelIn);
                this.setMailboxContents(uuid, mailbox);
                class_3222 player = PlatformHelper.getCurrentServer().method_3760().method_14602(uuid);
                if (player != null) {
                    ActionMessage packet = ActionMessage.create(0);
                    packet.sendTo(player);
                }
                return true;
            }
        }
        return false;
    }

    public void setMailboxContents(UUID uuid, class_1277 contents) {
        this.uuidToContents.put(uuid, contents);
    }

    public void resetMailboxContents(UUID uuid) {
        this.setMailboxContents(uuid, new class_1277(24));
    }

    @Nullable
    public UUID getMailboxOwner(class_5321<class_1937> level, class_2338 pos) {
        return this.locationToPlayer.get(class_4208.method_19443(level, (class_2338)pos));
    }

    @Nullable
    public class_4208 getMailboxPos(UUID uuid) {
        return this.uuidToLocation.get(uuid);
    }

    public void setMailboxData(UUID uuid, class_5321<class_1937> level, class_2338 pos) {
        class_2586 newTE;
        class_4208 newPos = class_4208.method_19443(level, (class_2338)pos);
        class_4208 oldPos = this.uuidToLocation.get(uuid);
        if (oldPos != null) {
            class_2586 oldTE;
            this.locationToPlayer.remove(oldPos);
            class_3218 oldLevel = PlatformHelper.getCurrentServer().method_3847(oldPos.method_19442());
            if (oldLevel != null && oldLevel.method_22340(oldPos.method_19446()) && (oldTE = oldLevel.method_8321(oldPos.method_19446())) instanceof MailboxBlockEntity) {
                ((MailboxBlockEntity)oldTE).refreshStatus();
            }
        }
        this.uuidToLocation.put(uuid, newPos);
        this.locationToPlayer.put(newPos, uuid);
        class_3218 newWorld = PlatformHelper.getCurrentServer().method_3847(level);
        if (newWorld != null && newWorld.method_22340(newPos.method_19446()) && (newTE = newWorld.method_8321(newPos.method_19446())) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)newTE).refreshStatus();
        }
    }

    public void removeMailboxData(class_4208 pos) {
        class_4208 mailboxPos;
        UUID uuid = this.locationToPlayer.remove(pos);
        if (uuid != null && Objects.equals(mailboxPos = this.uuidToLocation.get(uuid), pos)) {
            this.uuidToLocation.remove(uuid);
        }
    }

    public class_2487 writeToNBT(class_2487 tag) {
        int n = this.uuidToContents.size();
        tag.method_10569("MapDataSize", n);
        int i = 0;
        for (UUID uuid : this.uuidToContents.keySet()) {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("UUID", uuid.toString());
            compoundTag.method_10566("Contents", (class_2520)this.uuidToContents.getOrDefault(uuid, new class_1277(24)).method_7660());
            class_4208 globalPos = this.uuidToLocation.get(uuid);
            if (globalPos != null) {
                class_2960.field_25139.encodeStart((DynamicOps)class_2509.field_11560, (Object)globalPos.method_19442().method_29177()).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).ifPresent(world -> compoundTag.method_10566("MailboxDimension", world));
                compoundTag.method_10569("MailboxX", globalPos.method_19446().method_10263());
                compoundTag.method_10569("MailboxY", globalPos.method_19446().method_10264());
                compoundTag.method_10569("MailboxZ", globalPos.method_19446().method_10260());
            }
            tag.method_10566("MapData" + i, (class_2520)compoundTag);
            ++i;
        }
        tag.method_10569("MailListSize", this.mailList.size());
        for (i = 0; i < this.mailList.size(); ++i) {
            tag.method_10566("MailListData" + i, (class_2520)this.mailList.get(i).writeToNBT());
        }
        tag.method_10569("NameMapSize", this.nameToUUID.size());
        i = 0;
        for (String name : this.nameToUUID.keySet()) {
            tag.method_10582("NameMap" + i, name);
            tag.method_10582("NameMapUUID" + i, this.nameToUUID.get(name).toString());
            ++i;
        }
        return tag;
    }

    public void readFromNBT(class_2487 tag) {
        UUID uuid;
        class_2487 compoundTag;
        int i;
        this.uuidToContents.clear();
        this.uuidToLocation.clear();
        this.locationToPlayer.clear();
        this.mailList.clear();
        this.nameToUUID.clear();
        int n = tag.method_10550("MapDataSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.method_10562("MapData" + i);
            uuid = UUID.fromString(compoundTag.method_10558("UUID"));
            class_1277 contents = new class_1277(24);
            contents.method_7659(compoundTag.method_10554("Contents", 10));
            this.uuidToContents.put(uuid, contents);
            if (!compoundTag.method_10545("MailboxDimension")) continue;
            class_2338 mailboxPos = new class_2338(compoundTag.method_10550("MailboxX"), compoundTag.method_10550("MailboxY"), compoundTag.method_10550("MailboxZ"));
            class_5321 mailboxWorld = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("MailboxDimension")).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).orElse(class_1937.field_25179);
            class_4208 globalPos = class_4208.method_19443((class_5321)mailboxWorld, (class_2338)mailboxPos);
            this.uuidToLocation.put(uuid, globalPos);
            this.locationToPlayer.put(globalPos, uuid);
        }
        n = tag.method_10550("MailListSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.method_10562("MailListData" + i);
            MailToBeSent mail = new MailToBeSent(compoundTag);
            this.mailList.add(mail);
        }
        n = tag.method_10550("NameMapSize");
        for (i = 0; i < n; ++i) {
            String name = tag.method_10558("NameMap" + i);
            uuid = UUID.fromString(tag.method_10558("NameMapUUID" + i));
            this.nameToUUID.put(name, uuid);
        }
    }
}

