/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.tileentity;

import com.flechazo.contact.common.block.MailboxBlock;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class MailboxBlockEntity
extends class_2586 {
    private boolean isOpened = false;
    private boolean needRefresh = false;
    private int refreshTicks = 20;
    private int checkToSendTicks = 0;
    private int angel = 0;

    public MailboxBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super((class_2591)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.isOpened = nbt.method_10577("IsOpened");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("IsOpened", this.isOpened);
    }

    public boolean checkToSend() {
        if (this.checkToSendTicks <= 0) {
            this.checkToSendTicks = 60;
            return false;
        }
        return true;
    }

    public void refreshStatus() {
        if (!this.field_11863.field_9236) {
            boolean now;
            IMailboxDataProvider data = MailboxDataManager.getData(this.field_11863);
            boolean bl = now = !data.isMailboxEmpty(data.getMailboxOwner((class_5321<class_1937>)this.field_11863.method_27983(), this.method_11016()));
            if (now != this.isOpened) {
                this.needRefresh = true;
                this.isOpened = now;
                this.refresh();
            }
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MailboxBlockEntity blockEntity) {
        if (!level.field_9236) {
            if (blockEntity.refreshTicks >= 0) {
                --blockEntity.refreshTicks;
            }
            if (blockEntity.checkToSendTicks > 0) {
                --blockEntity.checkToSendTicks;
            }
            if (blockEntity.needRefresh || blockEntity.refreshTicks == 0) {
                blockEntity.refreshStatus();
                class_2680 down = level.method_8320(pos.method_10074());
                if (!(down.method_26204() instanceof MailboxBlock) || (Boolean)down.method_11654((class_2769)MailboxBlock.OPEN) == blockEntity.isOpened) {
                    blockEntity.needRefresh = false;
                    return;
                }
                level.method_8501(pos.method_10074(), (class_2680)down.method_11657((class_2769)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                blockEntity.needRefresh = false;
                if (state.method_26204() instanceof MailboxBlock) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                }
            }
        } else if (blockEntity.isOpened) {
            ++blockEntity.angel;
            blockEntity.angel %= 40;
        }
    }

    private void refresh() {
        if (this.method_11002() && !this.field_11863.field_9236) {
            class_2622 packet = class_2622.method_38585((class_2586)this);
            List players = ((class_3218)this.field_11863).method_14178().field_17254.method_17210(new class_1923(this.method_11016().method_10263() >> 4, this.method_11016().method_10260() >> 4), false);
            for (class_3222 player : players) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public int getAngel() {
        return this.angel;
    }
}

