/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.fabric.network;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3248;
import net.minecraft.class_635;
import net.minecraft.server.MinecraftServer;

public final class VersionCheckHandler {
    public static final class_2960 VERSION_CHECK = new class_2960("contact", "version");

    public static void registerServerMessage() {
        ServerLoginConnectionEvents.QUERY_START.register(VersionCheckHandler::onLoginQueryStart);
        ServerLoginNetworking.registerGlobalReceiver((class_2960)VERSION_CHECK, VersionCheckHandler::onServerLoginCheck);
    }

    public static void registerClientMessage() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)VERSION_CHECK, VersionCheckHandler::onClientLoginQuery);
    }

    private static void onLoginQueryStart(class_3248 serverLoginPacketListener, MinecraftServer server, PacketSender sender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        class_2540 versionCheck = PacketByteBufs.create();
        sender.sendPacket(VERSION_CHECK, versionCheck);
    }

    private static CompletableFuture<class_2540> onClientLoginQuery(class_310 client, class_635 clientLoginNetworkHandler, class_2540 buf, Consumer<GenericFutureListener<? extends Future<? super Void>>> genericFutureListenerConsumer) {
        class_2540 response = PacketByteBufs.create();
        response.method_10788("1.0", Short.MAX_VALUE);
        return CompletableFuture.completedFuture(response);
    }

    private static void onServerLoginCheck(MinecraftServer server, class_3248 handler, boolean responded, class_2540 buf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        try {
            String version = buf.method_10800(Short.MAX_VALUE);
            if (!Objects.equals("1.0", version)) {
                handler.method_14380((class_2561)class_2561.method_43471((String)"message.contact.disconnect.mismatch"));
            }
        }
        catch (Exception ignored) {
            handler.method_14380((class_2561)class_2561.method_43470((String)"Version is out-of-date. Please update your Contact mod."));
        }
    }
}

