/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.helper;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public final class GuiHelper {
    public static void drawTexturedModalRect(class_4587 poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tesselator = class_289.method_1348();
        class_287 wr = tesselator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        wr.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)x, (float)y, zLevel).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
        tesselator.method_1350();
    }

    public static void drawLayer(class_4587 poseStack, int x, int y, TexturePos pos, int z) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), z);
    }

    public static void drawLayer(class_4587 poseStack, int x, int y, TexturePos pos) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), 0.0f);
    }

    public static void drawLayer(class_332 guiGraphics, int x, int y, class_2960 rl, TexturePos pos) {
        guiGraphics.method_25302(rl, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight());
    }

    public static void drawLayerBySize(class_332 guiGraphics, class_2960 rl, int x, int y, TexturePos pos, int textureWidth, int textureHeight) {
        guiGraphics.method_25293(rl, x, y, pos.getWidth(), pos.getHeight(), (float)pos.getX(), (float)pos.getY(), pos.getWidth(), pos.getHeight(), textureWidth, textureHeight);
    }

    public static void drawLayerBySize(class_332 guiGraphics, class_2960 rl, int x, int y, TexturePos pos) {
        GuiHelper.drawLayerBySize(guiGraphics, rl, x, y, pos, pos.getWidth(), pos.getHeight());
    }

    public static void renderIconButton(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY, int z, class_2960 texture, IconButton button, TexturePos normalPos, TexturePos hoveredPos, TexturePos pressedPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        if (button.isPressed()) {
            GuiHelper.drawLayer(guiGraphics.method_51448(), button.method_46426(), button.method_46427(), pressedPos);
            RenderSystem.disableBlend();
            return;
        }
        if (button.method_49606()) {
            GuiHelper.drawLayer(guiGraphics.method_51448(), button.method_46426(), button.method_46427(), hoveredPos);
            RenderSystem.disableBlend();
            return;
        }
        GuiHelper.drawLayer(guiGraphics.method_51448(), button.method_46426(), button.method_46427(), normalPos);
        RenderSystem.disableBlend();
        button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void renderButton(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY, int z, class_2960 texture, class_4185 button, TexturePos normalPos, TexturePos hoveredPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        if (button.method_49606()) {
            GuiHelper.drawLayer(guiGraphics.method_51448(), button.method_46426(), button.method_46427(), hoveredPos);
        } else {
            GuiHelper.drawLayer(guiGraphics.method_51448(), button.method_46426(), button.method_46427(), normalPos);
        }
        RenderSystem.disableBlend();
        button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void drawTransparentStringDefault(class_327 font, String text, float x, float y, int color, boolean shadow) {
        GuiHelper.drawSpecialString(font, text, x, y, color, shadow, true, 0, 0xF000F0);
    }

    public static void drawSpecialString(class_327 font, String text, float x, float y, int color, boolean shadow, boolean transparent, int colorBackground, int packedLight) {
        class_4597.class_4598 iRenderTypeBuffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        font.method_27521(text, x, y, color, shadow, class_4590.method_22931().method_22936(), (class_4597)iRenderTypeBuffer, transparent ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, colorBackground, packedLight);
        iRenderTypeBuffer.method_22993();
    }

    public static void drawTooltip(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int weight, int height, List<class_2561> list) {
        if (x <= mouseX && mouseX <= x + weight && y <= mouseY && mouseY <= y + height) {
            guiGraphics.method_51437(class_310.method_1551().field_1772, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void drawFluidTooltip(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height, class_2561 name, int amount) {
        if (amount != 0) {
            ArrayList list = Lists.newArrayList((Object[])new class_2561[]{name});
            DecimalFormat df = new DecimalFormat("#,###");
            list.add(class_2561.method_43470((String)(df.format(amount) + " mB")).method_27692(class_124.field_1080));
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, x, y, width, height, list);
        }
    }

    private static float getCorrespondingUV(float min, float max, int uv) {
        return min + (max - min) * (float)uv / 16.0f;
    }

    static void innerBlit(int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.enableBlend();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912((double)x0, (double)y1, (double)z).method_22913(u0, v1).method_1344();
        buffer.method_22912((double)x1, (double)y1, (double)z).method_22913(u1, v1).method_1344();
        buffer.method_22912((double)x1, (double)y0, (double)z).method_22913(u1, v0).method_1344();
        buffer.method_22912((double)x0, (double)y0, (double)z).method_22913(u0, v0).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }
}

