/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.Contact;
import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.screenhandler.PackageScreenHandler;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.screenhandler.RedPacketEnvelopeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class ActionMessage {
    private static final class_2960 ID = new class_2960("contact", "action");
    private final int action;
    private final String extra;

    public ActionMessage(int action, String extra) {
        this.action = action;
        this.extra = extra;
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.action);
        buf.method_10788(this.extra != null ? this.extra : "", Short.MAX_VALUE);
    }

    public static ActionMessage decode(class_2540 buf) {
        try {
            int action = buf.readInt();
            String extra = buf.method_10800(Short.MAX_VALUE);
            return new ActionMessage(action, extra.isEmpty() ? null : extra);
        }
        catch (Exception e) {
            Contact.error("[ActionMessage/decode] Failed to decode, buf readableBytes=" + buf.readableBytes(), e);
            throw e;
        }
    }

    public void handleClient() {
        class_1703 class_17032;
        class_310 client = class_310.method_1551();
        if (this.action == 0) {
            ClientProxy.notifyNewMail(client);
        } else if (this.action == 1 && client.field_1724 != null && (class_17032 = client.field_1724.field_7512) instanceof PostboxScreenHandler) {
            PostboxScreenHandler container = (PostboxScreenHandler)class_17032;
            container.status = (byte)2;
        }
    }

    public void handleServer(class_3222 player) {
        if (player == null) {
            return;
        }
        if (this.action == 0) {
            ActionMessage.packParcel(player, this.extra);
        }
    }

    public static ActionMessage create(int action) {
        return new ActionMessage(action, null);
    }

    public static ActionMessage create(int action, String extra) {
        return new ActionMessage(action, extra);
    }

    private static void packParcel(class_3222 player, String extra) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof PackageScreenHandler) {
            PackageScreenHandler screenHandler = (PackageScreenHandler)class_17032;
            screenHandler.isPacked = true;
            if (screenHandler instanceof RedPacketEnvelopeScreenHandler) {
                RedPacketEnvelopeScreenHandler redPacket = (RedPacketEnvelopeScreenHandler)screenHandler;
                redPacket.blessings = extra;
            }
            player.method_7346();
        }
    }

    public void sendTo(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public void sendToServer() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((class_2960)ID, (class_2540)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)ID, (buf, ctx) -> {
            ActionMessage msg = ActionMessage.decode(buf);
            class_3222 player = (class_3222)ctx.getPlayer();
            if (player != null) {
                player.field_13995.execute(() -> msg.handleServer(player));
            }
        });
    }

    public static void registerS2C() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)ID, (buf, ctx) -> {
            ActionMessage msg = ActionMessage.decode(buf);
            class_310 mc = class_310.method_1551();
            mc.execute(msg::handleClient);
        });
    }
}

