/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class AddresseeDataMessage {
    private static final class_2960 ID = new class_2960("contact", "addressee_data");
    private final List<String> names;
    private final List<Integer> ticks;

    public AddresseeDataMessage(List<String> names, List<Integer> ticks) {
        this.names = names;
        this.ticks = ticks;
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.names.size());
        for (String name : this.names) {
            buf.method_10788(name, Short.MAX_VALUE);
        }
        Iterator<Object> iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            int tick = (Integer)iterator.next();
            buf.writeInt(tick);
        }
    }

    public static AddresseeDataMessage decode(class_2540 buf) {
        int i;
        int size = buf.readInt();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            names.add(buf.method_10800(Short.MAX_VALUE));
        }
        for (i = 0; i < size; ++i) {
            ticks.add(buf.readInt());
        }
        return new AddresseeDataMessage(names, ticks);
    }

    public void handleClient() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1703 class_17032 = client.field_1724.field_7512;
        if (class_17032 instanceof PostboxScreenHandler) {
            PostboxScreenHandler container = (PostboxScreenHandler)class_17032;
            container.names = this.names;
            container.ticks = this.ticks;
        }
    }

    public static AddresseeDataMessage create(List<String> names, List<Integer> ticks) {
        return new AddresseeDataMessage(names, ticks);
    }

    public void sendTo(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void registerS2C() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)ID, (buf, ctx) -> {
            AddresseeDataMessage msg = AddresseeDataMessage.decode(buf);
            class_310 mc = class_310.method_1551();
            mc.execute(msg::handleClient);
        });
    }
}

