/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.network.ActionMessage;
import com.flechazo.contact.network.AddresseeDataMessage;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class EnquireAddresseeMessage {
    private static final class_2960 ID = new class_2960("contact", "enquire_addressee");
    private final String nameIn;
    private final boolean shouldSend;

    public EnquireAddresseeMessage(String name, boolean shouldSend) {
        this.nameIn = name;
        this.shouldSend = shouldSend;
    }

    public void encode(class_2540 buf) {
        buf.method_10788(this.nameIn, Short.MAX_VALUE);
        buf.writeBoolean(this.shouldSend);
    }

    public static EnquireAddresseeMessage decode(class_2540 buf) {
        String name = buf.method_10800(Short.MAX_VALUE);
        boolean shouldSend = buf.readBoolean();
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void handleServer(class_3222 player) {
        if (player == null || this.nameIn.isEmpty()) {
            return;
        }
        IMailboxDataProvider data = MailboxDataManager.getData(player.field_13995);
        String lowerIn = this.nameIn.toLowerCase(Locale.ROOT);
        if (lowerIn.equals("@e") && player.field_13995.method_3835(player.method_7334()) >= 2) {
            this.handleAdminBroadcast(player, data);
            return;
        }
        this.handleNormalEnquiry(player, data, lowerIn);
    }

    private void handleAdminBroadcast(class_3222 player, IMailboxDataProvider data) {
        if (this.shouldSend) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof PostboxScreenHandler) {
                PostboxScreenHandler container = (PostboxScreenHandler)class_17032;
                class_1799 parcel = container.parcel.method_5438(0).method_7972();
                parcel.method_7948().method_10582("Sender", player.method_5477().getString());
                for (UUID uuid : data.getNameToUUID().values()) {
                    data.getMailList().add(new MailToBeSent(uuid, parcel.method_7972(), 0L));
                }
                ActionMessage.create(1).sendTo(player);
                container.parcel.method_5447(0, class_1799.field_8037);
            }
        } else {
            ArrayList<String> names = new ArrayList<String>();
            names.add("@e");
            ArrayList<Integer> ticks = new ArrayList<Integer>();
            ticks.add(0);
            AddresseeDataMessage.create(names, ticks).sendTo(player);
        }
    }

    private void handleNormalEnquiry(class_3222 player, IMailboxDataProvider data, String lowerIn) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : data.getNameToUUID().keySet()) {
            if (name.toLowerCase(Locale.ROOT).startsWith(lowerIn)) {
                names.add(name);
            }
            if (names.size() != 4) continue;
            break;
        }
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (String name : names) {
            UUID uuid = data.getNameToUUID().get(name);
            if (data.isMailboxFull(uuid)) {
                ticks.add(-1);
                continue;
            }
            class_4208 mailboxPos = data.getMailboxPos(uuid);
            if (!(player.field_7512 instanceof PostboxScreenHandler)) continue;
            int tick = 0;
            if (!((PostboxScreenHandler)player.field_7512).isEnderMail()) {
                tick = mailboxPos != null ? MailboxManager.getDeliveryTicks((class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), (class_5321<class_1937>)mailboxPos.method_19442(), mailboxPos.method_19446()) : (ContactCommonConfig.isEnableCenterMailbox() ? MailboxManager.getDeliveryTicks((class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), (class_5321<class_1937>)class_1937.field_25179, player.method_37908().method_43126()) : -2);
            }
            ticks.add(tick);
        }
        if (player.field_7512 instanceof PostboxScreenHandler) {
            if (this.shouldSend && !names.isEmpty() && Objects.equals(names.get(0), this.nameIn) && (Integer)ticks.get(0) >= 0) {
                this.handleSendMail(player, data, (String)names.get(0), (Integer)ticks.get(0));
            } else {
                AddresseeDataMessage.create(names, ticks).sendTo(player);
            }
        }
    }

    private void handleSendMail(class_3222 player, IMailboxDataProvider data, String recipientName, int deliveryTicks) {
        UUID uuid;
        class_4208 mailboxPos;
        PostboxScreenHandler container = (PostboxScreenHandler)player.field_7512;
        class_1799 parcel = container.parcel.method_5438(0);
        parcel.method_7948().method_10582("Sender", player.method_5477().getString());
        if (IPackageItem.checkAndPostmarkPostcard(parcel, player.method_5477().getString()) || parcel.method_7909() instanceof PostcardItem) {
            AdvancementManager.givePlayerAdvancement(player.field_13995, player, new class_2960("contact:send_postcard"));
        }
        if ((mailboxPos = data.getMailboxPos(uuid = data.getNameToUUID().get(recipientName))) != null) {
            if (mailboxPos.method_19442() != player.method_37908().method_27983()) {
                parcel.method_7948().method_10556("AnotherWorld", true);
            }
        } else if (class_1937.field_25179 != player.method_37908().method_27983()) {
            parcel.method_7948().method_10556("AnotherWorld", true);
        }
        data.getMailList().add(new MailToBeSent(uuid, parcel, deliveryTicks));
        ActionMessage.create(1).sendTo(player);
        container.parcel.method_5447(0, class_1799.field_8037);
    }

    public static EnquireAddresseeMessage create(String name, boolean shouldSend) {
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void sendToServer() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.encode(buf);
        NetworkManager.sendToServer((class_2960)ID, (class_2540)buf);
    }

    public static void registerC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)ID, (buf, ctx) -> {
            EnquireAddresseeMessage msg = EnquireAddresseeMessage.decode(buf);
            class_3222 player = (class_3222)ctx.getPlayer();
            if (player != null) {
                player.field_13995.execute(() -> msg.handleServer(player));
            }
        });
    }
}

