/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.common.item.ItemRegistry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NewMailToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent component, long ticks) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        List list = component.getMinecraft().font.split((FormattedText)Component.translatable((String)"info.contact.new_mail.desc"), 125);
        int titleColor = 0xFFFF00;
        int xTitle = 30;
        int xDesc = 30;
        if (list.size() == 1) {
            guiGraphics.drawString(component.getMinecraft().font, (Component)Component.translatable((String)"info.contact.new_mail.title"), xTitle, 7, titleColor | 0xFF000000, false);
            guiGraphics.drawString(component.getMinecraft().font, (FormattedCharSequence)list.getFirst(), xDesc, 18, -1, false);
        } else if (ticks < 1500L) {
            int fade = Mth.floor((float)(Mth.clamp((float)((float)(1500L - ticks) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            guiGraphics.drawString(component.getMinecraft().font, (Component)Component.translatable((String)"info.contact.new_mail.title"), xTitle, 11, titleColor | fade, false);
        } else {
            int fade = Mth.floor((float)(Mth.clamp((float)((float)(ticks - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int y = this.height() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence line : list) {
                guiGraphics.drawString(component.getMinecraft().font, line, xDesc, y, 0xFFFFFF | fade, false);
                y += 9;
            }
        }
        guiGraphics.renderFakeItem(new ItemStack((ItemLike)ItemRegistry.LETTER.get()), 8, 8);
        return ticks >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

