/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.helper.GuiHelper;
import com.flechazo.contact.network.EnquireAddresseeMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PostboxScreen
extends AbstractContainerScreen<PostboxScreenHandler> {
    private static final ResourceLocation RED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"textures/gui/red_postbox.png");
    private static final ResourceLocation GREEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"textures/gui/green_postbox.png");
    private final boolean isRed;
    private int offsetX;
    private int offsetY;
    private IconButton buttonSend;
    private EditBox nameField;
    private int selected = 0;

    public PostboxScreen(PostboxScreenHandler screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.isRed = screenContainer.isRed();
    }

    protected void init() {
        super.init();
        this.offsetX = (this.width - 176) / 2;
        this.offsetY = (this.height - 166) / 2 + 16;
        this.buttonSend = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.offsetX + 97, this.offsetY + 26, 10, 9, (Component)Component.translatable((String)"tooltip.contact.postbox.send"), button -> this.send(), this::buttonTooltip));
        this.nameField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.offsetX + 42, this.offsetY + 26, 44, 9, (Component)Component.translatable((String)"info.contact.postbox.addressee")));
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setValue(((PostboxScreenHandler)this.menu).playerName);
        this.nameField.setResponder(this::whileTyping);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(64);
        this.setInitialFocus((GuiEventListener)this.nameField);
    }

    private void buttonTooltip(Button button, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (button.isHovered()) {
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, button.getX(), button.getY(), button.getWidth(), button.getHeight(), Lists.newArrayList((Object[])new Component[]{button.getMessage()}));
        }
    }

    private void whileTyping(String name) {
        if (!((PostboxScreenHandler)this.menu).playerName.equals(name)) {
            ((PostboxScreenHandler)this.menu).playerName = name;
            if (((PostboxScreenHandler)this.menu).status == 2) {
                ((PostboxScreenHandler)this.menu).status = 1;
            }
            if (((PostboxScreenHandler)this.menu).status == 1) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.menu).playerName, false);
                packet.sendToServer();
            }
        }
    }

    private void send() {
        if (((PostboxScreenHandler)this.menu).status == 1) {
            if (this.isAddresseeValid() && ((PostboxScreenHandler)this.menu).ticks.get(0) >= 0) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.menu).playerName, true);
                packet.sendToServer();
            }
        } else if (((PostboxScreenHandler)this.menu).status == 2) {
            ((PostboxScreenHandler)this.menu).status = 0;
        }
        this.nameField.setFocused(false);
    }

    private boolean isAddresseeValid() {
        return !((PostboxScreenHandler)this.menu).names.isEmpty() && Objects.equals(this.nameField.getValue(), ((PostboxScreenHandler)this.menu).names.get(0));
    }

    protected void containerTick() {
        super.containerTick();
        if (((PostboxScreenHandler)this.menu).status == 1 && !this.nameField.getValue().equals(((PostboxScreenHandler)this.menu).playerName)) {
            this.nameField.setValue(((PostboxScreenHandler)this.menu).playerName);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((PostboxScreenHandler)this.menu).status == 1 && this.nameField.isFocused()) {
            int size = ((PostboxScreenHandler)this.menu).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.font.width(((PostboxScreenHandler)this.menu).names.get(i)) + 8, maxWidth);
            }
            if (size != 0 && (double)(this.offsetX + 42) <= mouseX && mouseX < (double)(this.offsetX + 42 + maxWidth) && (double)(this.offsetY + 40 + this.selected * 11) <= mouseY && mouseY < (double)(this.offsetY + 51 + this.selected * 11)) {
                this.nameField.setValue(((PostboxScreenHandler)this.menu).names.get(this.selected));
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
        boolean flag = false;
        if (((PostboxScreenHandler)this.menu).status == 1 && this.nameField.isFocused()) {
            int size = ((PostboxScreenHandler)this.menu).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.font.width(((PostboxScreenHandler)this.menu).names.get(i)) + 8, maxWidth);
            }
            int z = 5000;
            if (size != 0) {
                ResourceLocation texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
                int renderWidth = maxWidth;
                if (renderWidth == 55) {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 55, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 55, 2));
                } else {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 15, 2));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 36, texture, new TexturePos(216, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 39 + 11 * size, texture, new TexturePos(216, 65, 15, 2));
                    renderWidth -= 30;
                    int pos = 0;
                    while (renderWidth > 15) {
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, 15, 3 + 11 * size));
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, 15, 2));
                        renderWidth -= 15;
                        pos += 15;
                    }
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, renderWidth, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, renderWidth, 2));
                }
            }
            for (int i = 0; i < size; ++i) {
                if (this.offsetX + 42 <= mouseX && mouseX < this.offsetX + 42 + maxWidth && this.offsetY + 40 + i * 11 <= mouseY && mouseY < this.offsetY + 51 + i * 11) {
                    this.selected = i;
                    flag = true;
                }
                guiGraphics.drawString(this.font, ((PostboxScreenHandler)this.menu).names.get(i), this.offsetX + 42, this.offsetY + 40 + i * 11, (this.selected == i ? ChatFormatting.YELLOW.getColor() : ChatFormatting.WHITE.getColor()).intValue(), false);
            }
        }
        guiGraphics.pose().popPose();
        if (!flag) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        GuiHelper.drawLayer(guiGraphics.pose(), this.offsetX, this.offsetY, new TexturePos(0, 0, 176, 133));
        GuiHelper.renderButton(guiGraphics, partialTicks, x, y, 0, texture, this.buttonSend, new TexturePos(176, 0, 10, 9), new TexturePos(176, 9, 10, 9));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.postbox.addressee"), 40, 30, 0xE6E6E6, false);
        switch (((PostboxScreenHandler)this.menu).status) {
            case 0: {
                MutableComponent text = Component.translatable((String)"info.contact.postbox.need_mail");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 1: {
                if (this.isAddresseeValid()) {
                    int tick = ((PostboxScreenHandler)this.menu).ticks.get(0);
                    if (tick < 0) {
                        MutableComponent text = Component.translatable((String)"info.contact.postbox.no_mailbox");
                        this.renderTips(guiGraphics, text);
                        break;
                    }
                    MutableComponent text = Component.translatable((String)"info.contact.postbox.estimated");
                    int width = this.font.width(text.getString());
                    int min = tick / 1200;
                    int sec = tick % 1200 / 20;
                    if (width > 38) {
                        guiGraphics.drawString(this.font, (Component)text, 141 - width / 2, 26, 0x1A1A1A, false);
                        if (tick < 20) {
                            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.postbox.instant"), 141 - width / 2, 38, 0x1A1A1A, false);
                            break;
                        }
                        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 141 - width / 2, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.drawString(this.font, (Component)text, 122, 26, 0x1A1A1A, false);
                    if (tick < 20) {
                        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.postbox.instant"), 122, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 122, 38, 0x1A1A1A, false);
                    break;
                }
                MutableComponent text = Component.translatable((String)"info.contact.postbox.need_addressee");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 2: {
                MutableComponent text = Component.translatable((String)"info.contact.postbox.success");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 3: {
                MutableComponent text = Component.translatable((String)"info.contact.postbox.cannot_send");
                this.renderTips(guiGraphics, text);
            }
        }
    }

    private void renderTips(GuiGraphics guiGraphics, MutableComponent text) {
        int width = this.font.width(text.getString());
        if (width > 38) {
            List list = this.font.split((FormattedText)text, 50);
            for (int i = 0; i < list.size(); ++i) {
                guiGraphics.drawString(this.font, (FormattedCharSequence)list.get(i), 118, 38 - list.size() * 6 + i * 12, 0x1A1A1A, false);
            }
        } else {
            guiGraphics.drawString(this.font, (Component)text, 122, 32, 0x1A1A1A, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.nameField.keyPressed(keyCode, scanCode, modifiers) || this.nameField.isFocused() || super.keyPressed(keyCode, scanCode, modifiers);
    }
}

