/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.EditableTextBox;
import com.flechazo.contact.data.PostcardStyle;
import com.flechazo.contact.helper.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PostcardEditScreen
extends Screen {
    private final PostcardStyle style;
    private final EditableTextBox textBox;
    private Button buttonDone;
    private final ItemStack postcard;
    private final Player editingPlayer;
    private final InteractionHand hand;

    public PostcardEditScreen(ItemStack postcardIn, Player playerIn, InteractionHand handIn) {
        super((Component)Component.empty());
        this.postcard = postcardIn;
        this.editingPlayer = playerIn;
        this.hand = handIn;
        this.style = PostcardStyle.fromItemStack(postcardIn);
        this.textBox = (EditableTextBox)this.addRenderableOnly((Renderable)new EditableTextBox(this.postcard, this.editingPlayer, this.hand, (this.width - this.style.cardWidth()) / 2 + this.style.textPosX(), (this.height - this.style.cardHeight() - 30) / 2 + this.style.textPosY(), this.style.textWidth(), this.style.textHeight(), 12, this.style.textColor(), (Component)Component.literal((String)"Postcard")));
    }

    protected void init() {
        this.buttonDone = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.minecraft.setScreen(null);
            this.textBox.sendTextToServer();
        }).pos(this.width / 2 - 48, (this.height + this.style.cardHeight()) / 2 - 5).size(98, 20).build());
        this.textBox.setX((this.width - this.style.cardWidth()) / 2 + this.style.textPosX());
        this.textBox.setY((this.height - this.style.cardHeight() - 30) / 2 + this.style.textPosY());
        this.textBox.shouldRefresh();
        this.setInitialFocus((GuiEventListener)this.textBox);
    }

    public void tick() {
        super.tick();
        this.textBox.tick();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!super.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.textBox.mouseClicked(pMouseX, pMouseY, pButton);
        }
        return true;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            this.textBox.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderMenuBackground(guiGraphics);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawLayerBySize(guiGraphics, this.style.getCardTexture(), (this.width - this.style.cardWidth()) / 2, (this.height - this.style.cardHeight() - 30) / 2, new TexturePos(0, 0, this.style.cardWidth(), this.style.cardHeight()), this.style.cardWidth(), this.style.cardHeight());
        this.textBox.render(guiGraphics, mouseX, mouseY, delta);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, delta);
        }
    }
}

