/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.ReadOnlyTextBox;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.data.PostcardDataManager;
import com.flechazo.contact.data.PostcardStyle;
import com.flechazo.contact.helper.ColorHelper;
import com.flechazo.contact.helper.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PostcardReadScreen
extends Screen {
    private final PostcardStyle style;
    private final ItemStack postcard;
    private ReadOnlyTextBox textBox;
    private Button buttonDone;

    public PostcardReadScreen(ItemStack postcardIn) {
        super((Component)Component.empty());
        this.postcard = postcardIn;
        ResourceLocation styleId = (ResourceLocation)postcardIn.get((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get());
        this.style = PostcardDataManager.getPostcards().getOrDefault(styleId, PostcardStyle.DEFAULT);
    }

    protected void init() {
        this.textBox = new ReadOnlyTextBox(this.postcard, (this.width - this.style.cardWidth()) / 2 + this.style.textPosX(), this.style.textPosY() + (this.height - this.style.cardHeight() - 30) / 2, this.style.textWidth(), this.style.textHeight(), 12, this.style.textColor(), (Component)Component.literal((String)"Postcard"));
        this.buttonDone = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(null)).pos(this.width / 2 - 48, (this.height + this.style.cardHeight()) / 2 - 5).size(98, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderMenuBackground(guiGraphics);
        this.setFocused(null);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawLayerBySize(guiGraphics, this.style.getCardTexture(), (this.width - this.style.cardWidth()) / 2, (this.height - this.style.cardHeight() - 30) / 2, new TexturePos(0, 0, this.style.cardWidth(), this.style.cardHeight()), this.style.cardWidth(), this.style.cardHeight());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)ColorHelper.getRedF(this.style.postmarkColor()), (float)ColorHelper.getGreenF(this.style.postmarkColor()), (float)ColorHelper.getBlueF(this.style.postmarkColor()), (float)ColorHelper.getAlphaF(this.style.postmarkColor()));
        GuiHelper.drawLayerBySize(guiGraphics, this.style.getPostmarkTexture(), (this.width - this.style.cardWidth()) / 2 + this.style.postmarkPosX(), (this.height - this.style.cardHeight() - 30) / 2 + this.style.postmarkPosY(), new TexturePos(0, 0, this.style.postmarkWidth(), this.style.postmarkHeight()), this.style.postmarkWidth(), this.style.postmarkHeight());
        RenderSystem.disableBlend();
        this.textBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }
}

