/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.flechazo.contact.common.screenhandler.RedPacketEnvelopeScreenHandler;
import com.flechazo.contact.helper.GuiHelper;
import com.flechazo.contact.network.ActionC2SMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RedPacketEnvelopeScreen
extends AbstractContainerScreen<RedPacketEnvelopeScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"textures/gui/red_packet.png");
    private int offsetX;
    private int offsetY;
    private IconButton buttonPack;
    private EditBox blessings;

    public RedPacketEnvelopeScreen(RedPacketEnvelopeScreenHandler screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
        this.offsetX = (this.width - 176) / 2;
        this.offsetY = (this.height - 166) / 2 + 16;
        this.buttonPack = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.offsetX + 130, this.offsetY + 18, 8, 19, (Component)Component.translatable((String)"tooltip.contact.envelope.seal"), button -> this.seal(), this::buttonTooltip));
        this.blessings = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.offsetX + 66, this.offsetY + 26, 52, 9, (Component)Component.translatable((String)"info.contact.envelope.blessings")));
        this.blessings.setTextColor(-1);
        this.blessings.setTextColorUneditable(-1);
        this.blessings.setValue(((RedPacketEnvelopeScreenHandler)this.menu).blessings);
        this.blessings.setResponder(this::whileTyping);
        this.blessings.setBordered(false);
        this.blessings.setMaxLength(64);
        this.setInitialFocus((GuiEventListener)this.blessings);
    }

    private void buttonTooltip(Button button, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (button.isHovered()) {
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, button.getX(), button.getY(), button.getWidth(), button.getHeight(), Lists.newArrayList((Object[])new Component[]{button.getMessage()}));
        }
    }

    private void seal() {
        ActionC2SMessage packet = ActionC2SMessage.create(0, ((RedPacketEnvelopeScreenHandler)this.menu).blessings);
        packet.sendToServer();
    }

    private void whileTyping(String blessings) {
        if (!((RedPacketEnvelopeScreenHandler)this.menu).blessings.equals(blessings)) {
            ((RedPacketEnvelopeScreenHandler)this.menu).blessings = blessings;
        }
    }

    protected void containerTick() {
        super.containerTick();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"info.contact.red_packet.blessings"), 64, 30, 0xE6E6E6, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        GuiHelper.drawLayer(guiGraphics.pose(), this.offsetX, this.offsetY, new TexturePos(0, 0, 176, 133));
        GuiHelper.renderButton(guiGraphics, delta, mouseX, mouseY, 0, TEXTURE, this.buttonPack, new TexturePos(176, 0, 18, 19), new TexturePos(176, 19, 18, 19));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.blessings.keyPressed(keyCode, scanCode, modifiers) || this.blessings.isFocused() || super.keyPressed(keyCode, scanCode, modifiers);
    }
}

