/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.renderer;

import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MailboxTileEntityRenderer
implements BlockEntityRenderer<MailboxBlockEntity> {
    private final ItemRenderer itemRenderer;

    public MailboxTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(MailboxBlockEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (tileEntityIn.isOpened()) {
            ItemStack mail = new ItemStack((ItemLike)ItemRegistry.LETTER.get());
            poseStack.pushPose();
            poseStack.translate(0.5, 1.0 + 0.1 * (double)Mth.sin((float)((float)((double)((float)tileEntityIn.getAngel() + partialTicks) / 20.0 * Math.PI))), 0.5);
            poseStack.scale(0.6f, 0.6f, 0.6f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-Minecraft.getInstance().player.yHeadRot));
            this.itemRenderer.renderStatic(mail, ItemDisplayContext.FIXED, 0xF000F0, overlay, poseStack, vertexConsumers, tileEntityIn.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

