/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.renderer;

import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.entity.PostcardEntity;
import com.flechazo.contact.data.PostcardDataManager;
import com.flechazo.contact.data.PostcardStyle;
import com.flechazo.contact.helper.ColorHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class PostcardEntityRenderer<T extends PostcardEntity>
extends EntityRenderer<T> {
    private static final ModelResourceLocation PIN_NEO = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"block/postcard_pin"), "standalone");
    private static final ModelResourceLocation POSTCARD_NEO = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"block/postcard"), "standalone");
    private static final ModelResourceLocation PIN_FA = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"block/postcard_pin"), "fabric_resource");
    private static final ModelResourceLocation POSTCARD_FA = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"block/postcard"), "fabric_resource");
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final List<String> list = Lists.newArrayList();
    private int textHash = 0;

    public PostcardEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        super.render(entity, yaw, tickDelta, poseStack, multiBufferSource, light);
        poseStack.pushPose();
        Direction direction = entity.getDirection();
        Vec3 vec3d = this.getRenderOffset(entity, tickDelta);
        poseStack.translate(-vec3d.x(), -vec3d.y(), -vec3d.z());
        double d = 0.46875;
        poseStack.translate((double)direction.getStepX() * d, (double)direction.getStepY() * d, (double)direction.getStepZ() * d);
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        boolean bl = entity.isInvisible();
        ItemStack postcard = ((PostcardEntity)((Object)entity)).getPostcard();
        if (!postcard.isEmpty()) {
            String text;
            ResourceLocation styleId = (ResourceLocation)postcard.get((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get());
            PostcardStyle postcardStyle = PostcardDataManager.getPostcards().getOrDefault(styleId, PostcardStyle.DEFAULT);
            float width = (float)postcardStyle.cardWidth() / 2.0f;
            float height = (float)postcardStyle.cardHeight() / 2.0f;
            int j = ((PostcardEntity)((Object)entity)).getRotation();
            if (direction.get3DDataValue() > 1) {
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)((j + 1) % 3 - 1) * 360.0f / 16.0f));
            } else {
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)j * 360.0f / 16.0f));
            }
            ModelManager modelManager = this.blockRenderDispatcher.getBlockModelShaper().getModelManager();
            if (!bl && direction.get3DDataValue() > 1) {
                float red = ColorHelper.getRedF(postcardStyle.postmarkColor());
                float green = ColorHelper.getGreenF(postcardStyle.postmarkColor());
                float blue = ColorHelper.getBlueF(postcardStyle.postmarkColor());
                poseStack.pushPose();
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                poseStack.translate(0.0f, -(128.0f - height) / 256.0f, 0.0f);
                if (Platform.isFabric()) {
                    this.blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(Sheets.solidBlockSheet()), null, modelManager.getModel(PIN_FA), red, green, blue, light, OverlayTexture.NO_OVERLAY);
                }
                if (Platform.isNeoForge()) {
                    this.blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(Sheets.solidBlockSheet()), null, modelManager.getModel(PIN_NEO), red, green, blue, light, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
            }
            poseStack.pushPose();
            poseStack.scale(width / 128.0f, height / 128.0f, 1.0f);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            if (Platform.isFabric()) {
                this.blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(Sheets.solidBlockSheet()), null, modelManager.getModel(POSTCARD_FA), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            }
            if (Platform.isNeoForge()) {
                this.blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(Sheets.solidBlockSheet()), null, modelManager.getModel(POSTCARD_NEO), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
            poseStack.translate(0.0f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.translate(-64.0f, -64.0f, 0.0f);
            poseStack.translate(0.0f, 0.0f, -1.0f);
            Matrix4f matrix4f = poseStack.last().pose();
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(ClientProxy.getPostcardCardRenderLayer(postcardStyle));
            float pointX0 = 64.0f - width / 2.0f;
            float pointX1 = 64.0f + width / 2.0f;
            float pointY0 = 64.0f - height / 2.0f;
            float pointY1 = 64.0f + height / 2.0f;
            vertexConsumer.addVertex(matrix4f, pointX0, pointY1, -0.01f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light);
            vertexConsumer.addVertex(matrix4f, pointX1, pointY1, -0.01f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light);
            vertexConsumer.addVertex(matrix4f, pointX1, pointY0, -0.01f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light);
            vertexConsumer.addVertex(matrix4f, pointX0, pointY0, -0.01f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light);
            String sender = (String)postcard.get((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get());
            if (sender != null && !sender.isEmpty()) {
                float markX0 = pointX0 + (float)postcardStyle.postmarkPosX() / 2.0f;
                float markY0 = pointY0 + (float)postcardStyle.postmarkPosY() / 2.0f;
                VertexConsumer vertex = multiBufferSource.getBuffer(ClientProxy.getPostcardPostmarkRenderLayer(postcardStyle));
                float markWidth = (float)postcardStyle.postmarkWidth() / 2.0f;
                float markHeight = (float)postcardStyle.postmarkHeight() / 2.0f;
                int red = ColorHelper.getRed(postcardStyle.postmarkColor());
                int green = ColorHelper.getGreen(postcardStyle.postmarkColor());
                int blue = ColorHelper.getBlue(postcardStyle.postmarkColor());
                int alpha = ColorHelper.getAlpha(postcardStyle.postmarkColor());
                vertex.addVertex(matrix4f, markX0, markY0 + markHeight, -0.02f).setColor(red, green, blue, alpha).setUv(0.0f, 1.0f).setLight(light);
                vertex.addVertex(matrix4f, markX0 + markWidth, markY0 + markHeight, -0.02f).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setLight(light);
                vertex.addVertex(matrix4f, markX0 + markWidth, markY0, -0.02f).setColor(red, green, blue, alpha).setUv(1.0f, 0.0f).setLight(light);
                vertex.addVertex(matrix4f, markX0, markY0, -0.02f).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setLight(light);
            }
            if ((text = (String)postcard.get((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get())) != null && !text.isBlank()) {
                Font font = Minecraft.getInstance().font;
                float textX0 = pointX0 + (float)postcardStyle.textPosX() / 2.0f;
                float textY0 = pointY0 + (float)postcardStyle.textPosY() / 2.0f;
                if (this.textHash != text.hashCode()) {
                    this.list.clear();
                    font.getSplitter().splitLines(text, postcardStyle.textWidth(), Style.EMPTY, true, (style, lineStartPos, lineEndPos) -> {
                        String lineTextRaw = text.substring(lineStartPos, lineEndPos);
                        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
                        this.list.add(lineText);
                    });
                    this.textHash = text.hashCode();
                }
                poseStack.pushPose();
                poseStack.translate(textX0, textY0, -0.025f);
                poseStack.scale(0.5f, 0.5f, 1.0f);
                poseStack.translate(0.0f, 0.0f, -0.1f);
                for (String t : this.list) {
                    font.drawInBatch(t, 0.0f, 0.0f, postcardStyle.textColor(), false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
                    poseStack.translate(0.0f, 12.0f, 0.0f);
                }
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public Vec3 getRenderOffset(T entity, float f) {
        return new Vec3((double)((float)entity.getDirection().getStepX() * 0.3f), -0.25, (double)((float)entity.getDirection().getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(T entity) {
        if (!Minecraft.renderNames() || ((PostcardEntity)((Object)entity)).getPostcard().isEmpty() || !((PostcardEntity)((Object)entity)).getPostcard().has(DataComponents.CUSTOM_NAME) || this.entityRenderDispatcher.crosshairPickEntity != entity) {
            return false;
        }
        double d = this.entityRenderDispatcher.distanceToSqr(entity);
        float f = entity.isDiscrete() ? 32.0f : 64.0f;
        return d < (double)(f * f);
    }
}

