/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.widget;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.network.PostcardEditMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class EditableTextBox
extends AbstractWidget {
    private final Minecraft mc = Minecraft.getInstance();
    private final Font font;
    private boolean isModified = false;
    private int updateCount = 0;
    private long lastClickTime = 0L;
    private final int color;
    private final int spacing;
    private final TextFieldHelper textInputUtil;
    @Nullable
    private Page currentPage = null;
    private String page = "";
    private final ItemStack item;
    private final Player editingPlayer;
    private final InteractionHand hand;

    public EditableTextBox(ItemStack item, Player playerIn, InteractionHand handIn, int x, int y, int boxWidth, int boxHeight, int spacingPixel, int color, Component title) {
        super(x, y, boxWidth, boxHeight, title);
        this.font = this.mc.font;
        this.color = color;
        this.spacing = spacingPixel;
        this.item = item;
        this.editingPlayer = playerIn;
        this.hand = handIn;
        String text = (String)item.get((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get());
        this.page = text != null ? text : "";
        this.textInputUtil = new TextFieldHelper(() -> this.page, this::setText, this::getClipboardText, this::setClipboardText, text1 -> {
            if (text1.length() >= 1024) return false;
            int n = this.font.wordWrapHeight(text1, boxWidth);
            Objects.requireNonNull(this.font);
            if (n > boxHeight * 9 / spacingPixel) return false;
            return true;
        });
    }

    public void tick() {
        ++this.updateCount;
    }

    public void sendTextToServer() {
        if (this.isModified) {
            this.item.set((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)this.page);
            int i = this.hand == InteractionHand.MAIN_HAND ? this.editingPlayer.getInventory().selected : 40;
            PostcardEditMessage packet = PostcardEditMessage.create(this.item, i);
            packet.sendToServer();
        }
    }

    private Page createPage() {
        Point point;
        boolean flag;
        if (this.page.isEmpty()) {
            return Page.EMPTY;
        }
        int selectionStart = this.textInputUtil.getCursorPos();
        int selectionEnd = this.textInputUtil.getSelectionPos();
        IntArrayList intlist = new IntArrayList();
        ArrayList lines = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringSplitter = this.font.getSplitter();
        stringSplitter.splitLines(this.page, this.width, Style.EMPTY, true, (arg_0, arg_1, arg_2) -> this.lambda$createPage$2(mutableint, mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] linesStartPos = intlist.toIntArray();
        boolean bl = flag = selectionStart == this.page.length();
        if (flag && mutableboolean.isTrue()) {
            point = new Point(0, lines.size() * this.spacing);
        } else {
            int line = EditableTextBox.getCursorLine(linesStartPos, selectionStart);
            point = new Point(this.font.width(this.page.substring(linesStartPos[line], selectionStart)), line * this.spacing);
        }
        ArrayList rectangleList = Lists.newArrayList();
        if (selectionStart != selectionEnd) {
            int selectionEndLine;
            int selectionMin = Math.min(selectionStart, selectionEnd);
            int selectionMax = Math.max(selectionStart, selectionEnd);
            int selectionStartLine = EditableTextBox.getCursorLine(linesStartPos, selectionMin);
            if (selectionStartLine == (selectionEndLine = EditableTextBox.getCursorLine(linesStartPos, selectionMax))) {
                int linePosY = selectionStartLine * this.spacing;
                int linePosX = linesStartPos[selectionStartLine];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, selectionMax, linePosY, linePosX));
            } else {
                int i3 = selectionStartLine + 1 > linesStartPos.length ? this.page.length() : linesStartPos[selectionStartLine + 1];
                rectangleList.add(this.getRectangle(this.page, stringSplitter, selectionMin, i3, selectionStartLine * this.spacing, linesStartPos[selectionStartLine]));
                for (int j3 = selectionStartLine + 1; j3 < selectionEndLine; ++j3) {
                    int j2 = j3 * this.spacing;
                    String s1 = this.page.substring(linesStartPos[j3], linesStartPos[j3 + 1]);
                    int k2 = (int)stringSplitter.stringWidth(s1);
                    rectangleList.add(this.getRectangle(new Point(0, j2), new Point(k2, j2 + 9)));
                }
                rectangleList.add(this.getRectangle(this.page, stringSplitter, linesStartPos[selectionEndLine], selectionMax, selectionEndLine * this.spacing, linesStartPos[selectionEndLine]));
            }
        }
        return new Page(this.page, point, flag, linesStartPos, lines.toArray(new Line[0]), rectangleList.toArray(new Rect2i[0]));
    }

    private Rect2i getRectangle(String text, StringSplitter characterManager, int from, int to, int lineStart, int lineEnd) {
        String s = text.substring(lineEnd, from);
        String s1 = text.substring(lineEnd, to);
        Point pointFrom = new Point((int)characterManager.stringWidth(s), lineStart);
        Point pointTo = new Point((int)characterManager.stringWidth(s1), lineStart + this.spacing);
        return this.getRectangle(pointFrom, pointTo);
    }

    private Rect2i getRectangle(Point pointFromIn, Point pointToIn) {
        Point pointFrom = this.getPointPosInScreen(pointFromIn);
        Point pointTo = this.getPointPosInScreen(pointToIn);
        int i = Math.min(pointFrom.x, pointTo.x);
        int j = Math.max(pointFrom.x, pointTo.x);
        int k = Math.min(pointFrom.y, pointTo.y);
        int l = Math.max(pointFrom.y, pointTo.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    private Page getPage() {
        if (this.currentPage == null) {
            this.currentPage = this.createPage();
        }
        return this.currentPage;
    }

    private void setText(String text) {
        this.page = text;
        this.isModified = true;
    }

    private String getClipboardText() {
        return this.mc != null ? TextFieldHelper.getClipboardContents((Minecraft)this.mc) : "";
    }

    private void setClipboardText(String text) {
        if (this.mc != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.mc, (String)text);
        }
    }

    public void shouldRefresh() {
        this.currentPage = null;
    }

    private void getDownLine() {
        this.toMoveCursorLine(1);
    }

    private void getUpLine() {
        this.toMoveCursorLine(-1);
    }

    private void toMoveCursorLine(int lineAdded) {
        int i = this.textInputUtil.getCursorPos();
        int j = this.getPage().getLineToMove(i, lineAdded);
        this.textInputUtil.setCursorPos(j, Screen.hasShiftDown());
    }

    private static int getCursorLine(int[] linesLength, int cursorPos) {
        int i = Arrays.binarySearch(linesLength, cursorPos);
        return i < 0 ? -(i + 2) : i;
    }

    private void moveToLineHead() {
        if (Screen.hasControlDown()) {
            this.textInputUtil.setCursorToStart(Screen.hasShiftDown());
        } else {
            int i = this.textInputUtil.getCursorPos();
            int j = this.getPage().getLineStartPos(i);
            this.textInputUtil.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    private void moveToLineEnd() {
        if (Screen.hasControlDown()) {
            this.textInputUtil.setCursorToEnd(Screen.hasShiftDown());
        } else {
            int i = this.textInputUtil.getCursorPos();
            int j = this.getPage().getLineEndPos(i);
            this.textInputUtil.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean flag = this.keyPressedInBook(keyCode, scanCode, modifiers);
        if (flag) {
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    private boolean keyPressedInBook(int keyCode, int scanCode, int modifiers) {
        if (Screen.isSelectAll((int)keyCode)) {
            this.textInputUtil.selectAll();
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            this.textInputUtil.copy();
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.textInputUtil.paste();
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            this.textInputUtil.cut();
            return true;
        }
        TextFieldHelper.CursorStep cursorStep = Screen.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        return switch (keyCode) {
            case 257, 335 -> {
                this.textInputUtil.insertText("\n");
                yield true;
            }
            case 259 -> {
                this.textInputUtil.removeFromCursor(-1, cursorStep);
                yield true;
            }
            case 261 -> {
                this.textInputUtil.removeFromCursor(1, cursorStep);
                yield true;
            }
            case 262 -> {
                this.textInputUtil.moveBy(1, Screen.hasShiftDown(), cursorStep);
                yield true;
            }
            case 263 -> {
                this.textInputUtil.moveBy(-1, Screen.hasShiftDown(), cursorStep);
                yield true;
            }
            case 264 -> {
                this.getDownLine();
                yield true;
            }
            case 265 -> {
                this.getUpLine();
                yield true;
            }
            case 268 -> {
                this.moveToLineHead();
                yield true;
            }
            case 269 -> {
                this.moveToLineEnd();
                yield true;
            }
            default -> false;
        };
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (super.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (StringUtil.isAllowedChatCharacter((char)codePoint)) {
            this.textInputUtil.insertText(Character.toString(codePoint));
            this.shouldRefresh();
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Page page = this.getPage();
        for (Line line : page.lines) {
            guiGraphics.drawString(this.font, line.lineTextComponent, line.x, line.y, this.color, false);
        }
        this.renderSelection(page.selection);
        this.renderCursor(guiGraphics, page.point, page.isInsert);
    }

    private void renderSelection(Rect2i[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (Rect2i rect : selection) {
            int x1 = rect.getX();
            int y1 = rect.getY();
            int x2 = x1 + rect.getWidth();
            int y2 = y1 + rect.getHeight();
            bufferBuilder.addVertex((float)x1, (float)y2, 0.0f);
            bufferBuilder.addVertex((float)x2, (float)y2, 0.0f);
            bufferBuilder.addVertex((float)x2, (float)y1, 0.0f);
            bufferBuilder.addVertex((float)x1, (float)y1, 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
        RenderSystem.disableColorLogicOp();
    }

    private void renderCursor(GuiGraphics guiGraphics, Point point, boolean isInsert) {
        if (this.updateCount / 6 % 2 == 0 && this.height != 0) {
            point = this.getPointPosInScreen(point);
            if (!isInsert) {
                guiGraphics.fill(point.x, point.y - 1, point.x + 1, point.y + 9, this.color);
            } else {
                guiGraphics.drawString(this.font, "_", point.x, point.y, this.color, false);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            long i = Util.getMillis();
            int j = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            if (j >= 0) {
                if (i - this.lastClickTime < 250L) {
                    if (!this.textInputUtil.isSelecting()) {
                        this.setSelectionRange(j);
                    } else {
                        this.textInputUtil.selectAll();
                    }
                } else {
                    this.textInputUtil.setCursorPos(j, Screen.hasShiftDown());
                }
                this.shouldRefresh();
            }
            this.lastClickTime = i;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            int i = this.getPage().getMousePointPosInText(this.font, this.getPointPosInBox(new Point((int)mouseX, (int)mouseY)), this.spacing);
            this.textInputUtil.setCursorPos(i, true);
            this.shouldRefresh();
        }
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    private void setSelectionRange(int cursorPos) {
        this.textInputUtil.setSelectionRange(StringSplitter.getWordPosition((String)this.page, (int)-1, (int)cursorPos, (boolean)false), StringSplitter.getWordPosition((String)this.page, (int)1, (int)cursorPos, (boolean)false));
    }

    private Point getPointPosInBox(Point pointIn) {
        return new Point(pointIn.x - this.getX(), pointIn.y - this.getY());
    }

    private Point getPointPosInScreen(Point pointIn) {
        return new Point(pointIn.x + this.getX(), pointIn.y + this.getY());
    }

    private /* synthetic */ void lambda$createPage$2(MutableInt mutableint, MutableBoolean mutableboolean, IntList intlist, List lines, Style style, int lineStartPos, int lineEndPos) {
        int lineCount = mutableint.getAndIncrement();
        String lineTextRaw = this.page.substring(lineStartPos, lineEndPos);
        mutableboolean.setValue(lineTextRaw.endsWith("\n"));
        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
        int y = lineCount * this.spacing;
        Point point = this.getPointPosInScreen(new Point(0, y));
        intlist.add(lineStartPos);
        lines.add(new Line(style, lineText, point.x, point.y));
    }

    static class Page {
        protected static final Page EMPTY = new Page("", new Point(0, 0), true, new int[]{0}, new Line[]{new Line(Style.EMPTY, "", 0, 0)}, new Rect2i[0]);
        private final String text;
        private final Point point;
        private final boolean isInsert;
        private final int[] linesStartPos;
        protected final Line[] lines;
        private final Rect2i[] selection;

        public Page(String text, Point point, boolean isInsert, int[] linesStartPos, Line[] lines, Rect2i[] selection) {
            this.text = text;
            this.point = point;
            this.isInsert = isInsert;
            this.linesStartPos = linesStartPos;
            this.lines = lines;
            this.selection = selection;
        }

        public int getMousePointPosInText(Font font, Point point, int spacingPixel) {
            int linePos = point.y / spacingPixel;
            if (linePos < 0) {
                return 0;
            }
            if (linePos >= this.lines.length) {
                return this.text.length();
            }
            Line line = this.lines[linePos];
            return this.linesStartPos[linePos] + font.getSplitter().plainIndexAtWidth(line.lineText, point.x, line.style);
        }

        public int getLineToMove(int cursorPos, int lineAdded) {
            int k;
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            int j = i + lineAdded;
            if (0 <= j && j < this.linesStartPos.length) {
                int l = cursorPos - this.linesStartPos[i];
                int i1 = this.lines[j].lineText.length();
                k = this.linesStartPos[j] + Math.min(l, i1);
            } else {
                k = cursorPos;
            }
            return k;
        }

        public int getLineStartPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i];
        }

        public int getLineEndPos(int cursorPos) {
            int i = EditableTextBox.getCursorLine(this.linesStartPos, cursorPos);
            return this.linesStartPos[i] + this.lines[i].lineText.length();
        }
    }

    record Point(int x, int y) {
    }

    static class Line {
        private final Style style;
        private final String lineText;
        protected final Component lineTextComponent;
        protected final int x;
        protected final int y;

        public Line(Style style, String text, int x, int y) {
            this.style = style;
            this.lineText = text;
            this.x = x;
            this.y = y;
            this.lineTextComponent = Component.literal((String)text).setStyle(style);
        }
    }
}

