/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IconButton
extends Button {
    private boolean isPressed = false;
    protected final OnTooltip onTooltip;

    public IconButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.onTooltip = null;
    }

    public IconButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, OnTooltip tooltip) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.onTooltip = tooltip;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isHovered()) {
            this.renderToolTip(guiGraphics, mouseX, mouseY);
        }
    }

    public void renderToolTip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.onTooltip != null) {
            this.onTooltip.onTooltip(this, guiGraphics, pMouseX, pMouseY);
        }
    }

    public void onPress() {
        super.onPress();
        this.isPressed = true;
    }

    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        this.isPressed = false;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, GuiGraphics var2, int var3, int var4);
    }
}

