/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.widget;

import com.flechazo.contact.client.widget.EditableTextBox;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class ReadOnlyTextBox
extends AbstractWidget {
    private final Minecraft mc = Minecraft.getInstance();
    private final Font font;
    private final int color;
    private final int spacing;
    private final EditableTextBox.Page currentPage;
    private String page = "";

    public ReadOnlyTextBox(ItemStack item, int x, int y, int boxWidth, int boxHeight, int spacingPixel, int color, Component title) {
        super(x, y, boxWidth, boxHeight, title);
        this.font = this.mc.font;
        this.color = color;
        this.spacing = spacingPixel;
        String text = (String)item.get((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get());
        this.page = text != null ? text : "";
        this.currentPage = this.createPage();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    private EditableTextBox.Page createPage() {
        if (this.page.isEmpty()) {
            return EditableTextBox.Page.EMPTY;
        }
        IntArrayList intlist = new IntArrayList();
        ArrayList lines = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringSplitter = this.font.getSplitter();
        stringSplitter.splitLines(this.page, this.width, Style.EMPTY, true, (arg_0, arg_1, arg_2) -> this.lambda$createPage$0(mutableint, mutableboolean, (IntList)intlist, lines, arg_0, arg_1, arg_2));
        int[] linesStartPos = intlist.toIntArray();
        return new EditableTextBox.Page(this.page, new EditableTextBox.Point(0, 0), true, linesStartPos, lines.toArray(new EditableTextBox.Line[0]), new Rect2i[0]);
    }

    private EditableTextBox.Point getPointPosInScreen(EditableTextBox.Point pointIn) {
        return new EditableTextBox.Point(pointIn.x() + this.getX(), pointIn.y() + this.getY());
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (EditableTextBox.Line line : this.currentPage.lines) {
            guiGraphics.drawString(this.font, line.lineTextComponent, line.x, line.y, this.color, false);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    private /* synthetic */ void lambda$createPage$0(MutableInt mutableint, MutableBoolean mutableboolean, IntList intlist, List lines, Style style, int lineStartPos, int lineEndPos) {
        int lineCount = mutableint.getAndIncrement();
        String lineTextRaw = this.page.substring(lineStartPos, lineEndPos);
        mutableboolean.setValue(lineTextRaw.endsWith("\n"));
        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
        int y = lineCount * this.spacing;
        EditableTextBox.Point point = this.getPointPosInScreen(new EditableTextBox.Point(0, y));
        intlist.add(lineStartPos);
        lines.add(new EditableTextBox.Line(style, lineText, point.x(), point.y()));
    }
}

