/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.NormalHorizontalBlock;
import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class CenterMailboxBlock
extends NormalHorizontalBlock
implements ISilveroakEntry {
    public CenterMailboxBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            if (ContactCommonConfig.isEnableCenterMailbox()) {
                IMailboxDataProvider data = MailboxDataManager.getData(level);
                if (data.getMailboxPos(player.getUUID()) == null) {
                    SimpleContainer contents = data.getMailboxContents(player.getUUID());
                    boolean isEmpty = true;
                    for (int i = 0; i < contents.getContainerSize(); ++i) {
                        if (contents.getItem(i).isEmpty()) continue;
                        player.getInventory().placeItemBackInInventory(contents.getItem(i));
                        isEmpty = false;
                    }
                    data.resetMailboxContents(player.getUUID());
                    if (!isEmpty) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.pick_up"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.empty"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.deny"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.disabled"), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
    }

    @Override
    public ResourceLocation getRegistryID() {
        return Contact.getRL("center_mailbox");
    }
}

