/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.block;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.DoubleHorizontalBlock;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.helper.VoxelShapeHelper;
import com.flechazo.contact.platform.PlatformHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends DoubleHorizontalBlock
implements EntityBlock,
ISilveroakEntry {
    public static final MapCodec<MailboxBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("box_color").forGetter(block -> block.boxColor), (App)DyeColor.CODEC.optionalFieldOf("flag_color", (Object)DyeColor.RED).forGetter(block -> block.flagColor)).apply((Applicative)instance, MailboxBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public final DyeColor boxColor;
    public final DyeColor flagColor;
    public static final VoxelShape LOWER_SHAPE = VoxelShapeHelper.createVoxelShape(7.0, 0.0, 7.0, 2.0, 16.0, 2.0);
    public static final VoxelShape UPPER_SHAPE_NORTH = VoxelShapeHelper.createVoxelShape(3.0, 0.0, 1.0, 10.0, 9.0, 14.0);
    public static final VoxelShape UPPER_SHAPE_EAST = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 3.0, 14.0, 9.0, 10.0);

    public MailboxBlock(DyeColor boxColor, DyeColor flagColor) {
        super(BlockBehaviour.Properties.of().mapColor(boxColor).noOcclusion().sound(SoundType.STONE).strength(1.5f, 6.0f));
        this.boxColor = boxColor;
        this.flagColor = flagColor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public MailboxBlock(DyeColor boxColor) {
        this(boxColor, DyeColor.RED);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((DoubleBlockHalf)state.getValue((Property)HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return this.getLowerShape();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> UPPER_SHAPE_EAST;
            default -> UPPER_SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
    }

    @Override
    protected VoxelShape getLowerShape() {
        return LOWER_SHAPE;
    }

    @Override
    protected VoxelShape getUpperShape() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            BlockPos topPos = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? pos : pos.above();
            UUID mailboxOwner = data.getMailboxOwner((ResourceKey<Level>)level.dimension(), topPos);
            if (player.isShiftKeyDown() && mailboxOwner == null) {
                if (data.getMailboxPos(player.getUUID()) == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.binding"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.switch"), true);
                }
                data.setMailboxData(player.getUUID(), (ResourceKey<Level>)level.dimension(), topPos);
                MailboxManager.updateState(level, topPos);
                AdvancementManager.givePlayerAdvancement(level.getServer(), (ServerPlayer)player, ResourceLocation.parse((String)"contact:root"));
                return InteractionResult.SUCCESS;
            }
            if (Objects.equals(mailboxOwner, player.getUUID())) {
                SimpleContainer contents = data.getMailboxContents(mailboxOwner);
                boolean isEmpty = true;
                for (int i = 0; i < contents.getContainerSize(); ++i) {
                    ItemStack parcel = contents.getItem(i);
                    if (parcel.isEmpty()) continue;
                    if (parcel.getItem() instanceof PostcardItem) {
                        AdvancementManager.givePlayerAdvancement(level.getServer(), (ServerPlayer)player, ResourceLocation.parse((String)"contact:receive_postcard"));
                    }
                    if (parcel.has((DataComponentType)ContactDataComponents.ANOTHER_WORLD.get())) {
                        AdvancementManager.givePlayerAdvancement(level.getServer(), (ServerPlayer)player, ResourceLocation.parse((String)"contact:from_another_world"));
                    }
                    player.getInventory().placeItemBackInInventory(parcel);
                    isEmpty = false;
                }
                data.resetMailboxContents(mailboxOwner);
                if (!isEmpty) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.pick_up"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.empty"), true);
                }
                MailboxManager.updateState(level, topPos);
                return InteractionResult.SUCCESS;
            }
            if (mailboxOwner != null) {
                PlatformHelper.getCurrentServer().getProfileCache().get(mailboxOwner).ifPresent(gameProfile -> player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.others", (Object[])new Object[]{gameProfile.getName()}), true));
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.no_owner_tips"), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide && itemStack.getItem() instanceof IMailItem) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            BlockPos topPos = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? pos : pos.above();
            UUID mailboxOwner = data.getMailboxOwner((ResourceKey<Level>)level.dimension(), topPos);
            if (mailboxOwner != null) {
                ItemStack held = itemStack.copy();
                if (!held.has((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get())) {
                    if (!data.isMailboxFull(mailboxOwner)) {
                        MailboxBlockEntity mailbox;
                        BlockEntity blockEntity = level.getBlockEntity(topPos);
                        if (blockEntity instanceof MailboxBlockEntity && (mailbox = (MailboxBlockEntity)blockEntity).checkToSend()) {
                            held.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)player.getName().getString());
                            data.addMailboxContents(mailboxOwner, held);
                            itemStack.shrink(1);
                            player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.deliver"), true);
                            AdvancementManager.givePlayerAdvancement(player.getServer(), (ServerPlayer)player, ResourceLocation.parse((String)"contact:send_in_person"));
                            MailboxManager.updateState(level, topPos);
                            return ItemInteractionResult.SUCCESS;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.check"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.full"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.used"), true);
                }
                return ItemInteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.contact.mailbox.no_owner"), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide) {
            IMailboxDataProvider data = MailboxDataManager.getData(level);
            BlockPos topPos = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? pos : pos.above();
            data.removeMailboxData(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)topPos));
        }
        return state;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return MailboxBlock.createTickerHelper(type, MailboxBlockEntity::tick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityTicker<? super E> entityTicker) {
        return BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get() == blockEntityType ? entityTicker : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get()).create(pos, state);
    }

    @Override
    public ResourceLocation getRegistryID() {
        return Contact.getRL(this.boxColor.getName() + "_mailbox");
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

