/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.command;

import com.flechazo.contact.common.command.arguments.PostcardStyleArgument;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.ParcelItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.data.PostcardDataManager;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ContactCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PLAYERS = (context, builder) -> {
        MinecraftServer server = PlatformHelper.getCurrentServer();
        HashSet set = Sets.newHashSet();
        if (server != null) {
            IMailboxDataProvider data = MailboxDataManager.getData(server);
            set.addAll(data.getNameToUUID().keySet());
        }
        set.add("\"@e\"");
        return SharedSuggestionProvider.suggest((Iterable)set, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_POSTCARDS = (context, builder) -> {
        Set<ResourceLocation> collection = PostcardDataManager.getPostcards().keySet();
        return SharedSuggestionProvider.suggestResource(collection, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext access, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"contact").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"postcard").then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"postcard", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_POSTCARDS).then(((RequiredArgumentBuilder)Commands.argument((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), "", BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(((RequiredArgumentBuilder)Commands.argument((String)"sender", (ArgumentType)StringArgumentType.string()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))).then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))).then(Commands.literal((String)"deliver").then(Commands.argument((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.argument((String)"postcard", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_POSTCARDS).then(Commands.argument((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"sender", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"parcel").then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"item1", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.argument((String)"item2", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.argument((String)"item3", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.getItem((CommandContext)context, (String)"item3").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.argument((String)"item4", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(Commands.argument((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.getItem((CommandContext)context, (String)"item3").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.getItem((CommandContext)context, (String)"item4").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false)))))))))))))))).then(Commands.literal((String)"deliver").then(Commands.argument((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.argument((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).then(Commands.argument((String)"item1", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.argument((String)"item2", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.argument((String)"item3", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(((RequiredArgumentBuilder)Commands.argument((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.getItem((CommandContext)context, (String)"item3").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.argument((String)"item4", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).then(Commands.argument((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.getItem((CommandContext)context, (String)"item1").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.getItem((CommandContext)context, (String)"item2").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.getItem((CommandContext)context, (String)"item3").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.getItem((CommandContext)context, (String)"item4").createItemStack(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false))))))))))))))))));
    }

    private static void deliverToPlayerMailbox(CommandSourceStack source, String target, int ticks, AtomicInteger n, ItemStack parcel) {
        IMailboxDataProvider data = MailboxDataManager.getData(source.getServer());
        UUID uuid = data.getNameToUUID().get(target);
        if (uuid != null) {
            if (!data.isMailboxFull(uuid)) {
                data.getMailList().add(new MailToBeSent(uuid, parcel, ticks));
                n.getAndIncrement();
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.contact.deliver.full", (Object[])new Object[]{target}), true);
            }
        }
    }

    private static int deliverParcel(CommandSourceStack source, String target, int ticks, String sender, boolean isEnder, ItemStack ... list) {
        AtomicInteger n = new AtomicInteger(0);
        SimpleContainer contents = new SimpleContainer(4);
        for (int i = 0; i < list.length; ++i) {
            contents.setItem(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        if (target.equals("@e")) {
            IMailboxDataProvider data = MailboxDataManager.getData(source.getServer());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, parcel));
        } else {
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, parcel);
        }
        if (n.get() == 1 && target.equals("@e")) {
            source.sendSuccess(() -> Component.translatable((String)"command.contact.deliver.success.single", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).getHoverName(), target}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).getHoverName(), n.get()}), true);
        }
        return n.get();
    }

    private static int giveParcel(CommandSourceStack source, Collection<ServerPlayer> targets, String sender, boolean isEnder, ItemStack ... list) {
        SimpleContainer contents = new SimpleContainer(4);
        for (int i = 0; i < list.length; ++i) {
            contents.setItem(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        ContactCommand.giveParcelToPlayers(targets, parcel);
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).getHoverName(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).getHoverName(), targets.size()}), true);
        }
        return targets.size();
    }

    private static int deliverPostcard(CommandSourceStack source, ResourceLocation id, String target, int ticks, String sender, boolean isEnder, String text) {
        text = text.replace("\\n", "\n");
        AtomicInteger n = new AtomicInteger(0);
        if (target.equals("@e")) {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
            IMailboxDataProvider data = MailboxDataManager.getData(source.getServer());
            data.getNameToUUID().keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, postcard));
        } else {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, false), text);
            postcard.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, postcard);
        }
        if (n.get() == 1 && !target.equals("@e")) {
            source.sendSuccess(() -> Component.translatable((String)"command.contact.deliver.success.single", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).getHoverName(), target}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.contact.deliver.success.multiple", (Object[])new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).getHoverName(), n.get()}), true);
        }
        return n.get();
    }

    private static int givePostcard(CommandSourceStack source, ResourceLocation postcardId, Collection<ServerPlayer> targets, String sender, boolean isEnderType, String text) {
        ItemStack postcard = PostcardItem.getPostcard(postcardId, isEnderType);
        if (!sender.isEmpty()) {
            postcard.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
        }
        if (!text.isEmpty()) {
            postcard.set((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)text);
        }
        AtomicInteger i = new AtomicInteger();
        targets.forEach(player -> {
            player.getInventory().placeItemBackInInventory(postcard.copy());
            i.getAndIncrement();
        });
        source.sendSuccess(() -> Component.translatable((String)"commands.contact.postcard.give.success", (Object[])new Object[]{i.get()}), true);
        return i.get();
    }

    private static void giveParcelToPlayers(Collection<ServerPlayer> targets, ItemStack parcel) {
        for (ServerPlayer serverPlayer : targets) {
            boolean flag = serverPlayer.getInventory().add(parcel);
            if (flag) {
                ItemEntity itemEntity = serverPlayer.drop(parcel, false);
                if (itemEntity != null) {
                    itemEntity.makeFakeItem();
                }
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.inventoryMenu.broadcastChanges();
                continue;
            }
            ItemEntity itementity = serverPlayer.drop(parcel, false);
            if (itementity == null) continue;
            itementity.setNoPickUpDelay();
            itementity.setThrower((Entity)serverPlayer);
        }
    }
}

