/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.entity;

import com.flechazo.contact.common.entity.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class PostcardEntity
extends HangingEntity {
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.defineId(PostcardEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.defineId(PostcardEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean fixed;
    private static final double WIDTH = 12.0;
    private static final double HEIGHT = 12.0;

    public PostcardEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public PostcardEntity(Level level, BlockPos pos, Direction facing) {
        this((EntityType<? extends HangingEntity>)((EntityType)EntityTypeRegistry.POSTCARD.get()), level, pos, facing);
    }

    public PostcardEntity(EntityType<? extends HangingEntity> type, Level level, BlockPos pos, Direction facing) {
        super(type, level, pos);
        this.setDirection(facing);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(ROTATION, (Object)0);
    }

    protected void setDirection(Direction facing) {
        Validate.notNull((Object)facing);
        this.direction = facing;
        if (facing.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * facing.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    protected AABB calculateBoundingBox(BlockPos blockPos, Direction direction) {
        double e = (double)blockPos.getX() + 0.5 - (double)direction.getStepX() * 0.46875;
        double f = (double)blockPos.getY() + 0.5 - (double)direction.getStepY() * 0.46875;
        double g = (double)blockPos.getZ() + 0.5 - (double)direction.getStepZ() * 0.46875;
        double h = 12.0;
        double i = 12.0;
        double j = 12.0;
        Direction.Axis axis = direction.getAxis();
        switch (axis) {
            case X: {
                h = 1.0;
                break;
            }
            case Y: {
                i = 1.0;
                break;
            }
            case Z: {
                j = 1.0;
            }
        }
        return new AABB(e - (h /= 32.0), f - (i /= 32.0), g - (j /= 32.0), e + h, f + i, g + j);
    }

    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        if (!(blockState.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode((BlockState)blockState))) {
            return false;
        }
        return this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    public void move(MoverType moverType, Vec3 movement) {
        if (!this.fixed) {
            super.move(moverType, movement);
        }
    }

    public void push(double deltaX, double deltaY, double deltaZ) {
        if (!this.fixed) {
            super.push(deltaX, deltaY, deltaZ);
        }
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.fixed) {
            if (source.typeHolder().is(DamageTypes.FELL_OUT_OF_WORLD) || source.isCreativePlayer()) {
                return super.hurt(source, amount);
            }
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d;
        double d2 = 16.0;
        return distance < d * (d2 *= 64.0 * ItemFrame.getViewScale());
    }

    public void dropItem(@Nullable Entity entity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropPostcard(entity);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.ITEM_FRAME_BREAK;
    }

    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.ITEM_FRAME_PLACE;
    }

    private void dropPostcard(@Nullable Entity entity) {
        if (this.fixed) {
            return;
        }
        ItemStack postcard = this.getPostcard();
        this.setHeldItemStack(ItemStack.EMPTY);
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                return;
            }
        }
        if (!postcard.isEmpty()) {
            postcard = postcard.copy();
            this.spawnAtLocation(postcard);
        }
    }

    public ItemStack getPostcard() {
        return (ItemStack)this.getEntityData().get(ITEM_STACK);
    }

    public void setHeldItemStack(ItemStack value) {
        if (!value.isEmpty()) {
            value = value.copy();
            value.setCount(1);
        }
        this.setAsStackHolder(value);
        this.getEntityData().set(ITEM_STACK, (Object)value);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (data.equals(ITEM_STACK)) {
            this.setAsStackHolder(this.getPostcard());
        }
    }

    private void setAsStackHolder(ItemStack stack) {
        if (!stack.isEmpty() && stack.getEntityRepresentation() != this) {
            stack.setEntityRepresentation((Entity)this);
        }
        this.recalculateBoundingBox();
    }

    public int getRotation() {
        return (Integer)this.getEntityData().get(ROTATION);
    }

    private void setRotation(int value) {
        this.getEntityData().set(ROTATION, (Object)(value % 16));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.getPostcard().isEmpty()) {
            RegistryAccess provider = this.level().registryAccess();
            tag.put("Item", this.getPostcard().save((HolderLookup.Provider)provider));
            tag.putByte("ItemRotation", (byte)this.getRotation());
        }
        tag.putByte("Facing", (byte)this.direction.get3DDataValue());
        tag.putBoolean("Invisible", this.isInvisible());
        tag.putBoolean("Fixed", this.fixed);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        CompoundTag compoundTag = tag.getCompound("Item");
        if (!compoundTag.isEmpty()) {
            RegistryAccess provider = this.level().registryAccess();
            ItemStack postcard = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag);
            this.setHeldItemStack(postcard);
            this.setRotation(tag.getByte("ItemRotation"));
        }
        this.setDirection(Direction.from3DDataValue((int)tag.getByte("Facing")));
        this.setInvisible(tag.getBoolean("Invisible"));
        this.fixed = tag.getBoolean("Fixed");
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.getPostcard().isEmpty();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide()) {
            return isEmpty ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!isEmpty) {
            this.hurt(this.damageSources().playerAttack(player), 1.0f);
        }
        this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
        if (this.getDirection().get3DDataValue() > 1) {
            this.setRotation((this.getRotation() + 1) % 3);
        } else {
            this.setRotation(this.getRotation() + 1);
        }
        return InteractionResult.CONSUME;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setDirection(Direction.from3DDataValue((int)packet.getData()));
    }

    public ItemStack getPickResult() {
        return this.getPostcard();
    }

    public float getVisualRotationYInDegrees() {
        Direction direction = this.getDirection();
        int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + this.getRotation() * 45 + i));
    }
}

