/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.handler;

import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.data.PostcardDataManager;
import com.flechazo.contact.data.PostcardStyle;
import dev.architectury.event.EventResult;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public final class WanderingTraderSaleHandler {
    public static EventResult interact(Player player, Entity entity, InteractionHand hand) {
        WanderingTrader trader;
        if (!player.level().isClientSide && entity instanceof WanderingTrader && !(trader = (WanderingTrader)entity).getTags().contains("SellPostcard")) {
            Map<ResourceLocation, PostcardStyle> postcards = PostcardDataManager.getPostcards();
            int i = player.level().getRandom().nextInt(postcards.size());
            trader.addTag("SellPostcard");
            ResourceLocation id = postcards.keySet().toArray(new ResourceLocation[0])[i];
            PostcardStyle style = PostcardDataManager.getPostcard(id);
            for (int attempts = 0; !style.trade().soldByTrader() && attempts < postcards.size(); ++attempts) {
                i = player.level().getRandom().nextInt(postcards.size());
                id = postcards.keySet().toArray(new ResourceLocation[0])[i];
                style = PostcardDataManager.getPostcard(id);
            }
            if (style.trade().soldByTrader()) {
                trader.getOffers().add(0, (Object)new MerchantOffer(new ItemCost((ItemLike)style.trade().price().getItem(), style.trade().price().getCount()), Optional.of(new ItemCost((ItemLike)Items.ENDER_PEARL)), PostcardItem.getPostcard(id, true), 16, 10, 0.05f));
                trader.getOffers().add(0, (Object)new MerchantOffer(new ItemCost((ItemLike)style.trade().price().getItem(), style.trade().price().getCount()), PostcardItem.getPostcard(id, false), 16, 10, 0.05f));
            }
        }
        return EventResult.pass();
    }
}

