/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.item;

import com.flechazo.contact.client.item.PackageTooltipData;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.PostcardItem;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public interface IPackageItem {
    public int getCapacity();

    public static boolean checkAndPostmarkPostcard(ItemStack parcel, String sender) {
        Item item = parcel.getItem();
        if (item instanceof IPackageItem) {
            IPackageItem packageItem = (IPackageItem)item;
            ItemContainerContents contents = (ItemContainerContents)parcel.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
            SimpleContainer container = new SimpleContainer(packageItem.getCapacity());
            contents.copyInto(container.getItems());
            boolean postcard = false;
            for (int i = 0; i < packageItem.getCapacity(); ++i) {
                ItemStack item2 = container.getItem(i);
                if (!(item2.getItem() instanceof IMailItem)) continue;
                if (item2.getItem() instanceof PostcardItem) {
                    postcard = true;
                }
                item2.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
            }
            parcel.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)container.getItems()));
            return postcard;
        }
        return false;
    }

    public static void openPackage(IPackageItem item, Player user, InteractionHand hand) {
        ItemStack parcel = user.getItemInHand(hand);
        ItemContainerContents contents = (ItemContainerContents)parcel.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        SimpleContainer container = new SimpleContainer(item.getCapacity());
        contents.copyInto(container.getItems());
        for (int i = 0; i < item.getCapacity(); ++i) {
            user.getInventory().placeItemBackInInventory(container.getItem(i));
        }
    }

    public static PackageTooltipData getTooltipData(IPackageItem item, ItemStack stack) {
        ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        SimpleContainer container = new SimpleContainer(item.getCapacity());
        contents.copyInto(container.getItems());
        return new PackageTooltipData((NonNullList<ItemStack>)container.getItems());
    }
}

