/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.item;

import com.flechazo.contact.Contact;
import com.flechazo.contact.common.block.BlockRegistry;
import com.flechazo.contact.common.inter.ISilveroakEntry;
import com.flechazo.contact.common.item.EnvelopeItem;
import com.flechazo.contact.common.item.LetterItem;
import com.flechazo.contact.common.item.NormalBlockItem;
import com.flechazo.contact.common.item.ParcelItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.item.RedPacketEnvelopeItem;
import com.flechazo.contact.common.item.RedPacketItem;
import com.flechazo.contact.common.item.WrappingPaperItem;
import com.flechazo.contact.data.PostcardDataManager;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"contact", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<Item> LETTER = ItemRegistry.register("letter", LetterItem::new);
    public static final RegistrySupplier<Item> ENVELOPE = ItemRegistry.register("envelope", EnvelopeItem::new);
    public static final RegistrySupplier<Item> RED_PACKET = ItemRegistry.register("red_packet", RedPacketItem::new);
    public static final RegistrySupplier<Item> RED_PACKET_ENVELOPE = ItemRegistry.register("red_packet_envelope", RedPacketEnvelopeItem::new);
    public static final RegistrySupplier<Item> PARCEL = ItemRegistry.register("parcel", () -> new ParcelItem("parcel", false));
    public static final RegistrySupplier<Item> ENDER_PARCEL = ItemRegistry.register("ender_parcel", () -> new ParcelItem("ender_parcel", true));
    public static final RegistrySupplier<Item> POSTCARD = ItemRegistry.register("postcard", () -> new PostcardItem("postcard", false));
    public static final RegistrySupplier<Item> ENDER_POSTCARD = ItemRegistry.register("ender_postcard", () -> new PostcardItem("ender_postcard", true));
    public static final RegistrySupplier<Item> WRAPPING_PAPER = ItemRegistry.register("wrapping_paper", () -> new WrappingPaperItem("wrapping_paper"));
    public static final RegistrySupplier<Item> ENDER_WRAPPING_PAPER = ItemRegistry.register("ender_wrapping_paper", () -> new WrappingPaperItem("ender_wrapping_paper"));
    public static final RegistrySupplier<BlockItem> WHITE_MAILBOX_ITEM = ItemRegistry.register("white_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.WHITE_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> ORANGE_MAILBOX_ITEM = ItemRegistry.register("orange_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.ORANGE_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> MAGENTA_MAILBOX_ITEM = ItemRegistry.register("magenta_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.MAGENTA_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> LIGHT_BLUE_MAILBOX_ITEM = ItemRegistry.register("light_blue_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.LIGHT_BLUE_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> YELLOW_MAILBOX_ITEM = ItemRegistry.register("yellow_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.YELLOW_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> LIME_MAILBOX_ITEM = ItemRegistry.register("lime_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.LIME_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> PINK_MAILBOX_ITEM = ItemRegistry.register("pink_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.PINK_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> GRAY_MAILBOX_ITEM = ItemRegistry.register("gray_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.GRAY_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> LIGHT_GRAY_MAILBOX_ITEM = ItemRegistry.register("light_gray_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.LIGHT_GRAY_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> CYAN_MAILBOX_ITEM = ItemRegistry.register("cyan_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.CYAN_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> PURPLE_MAILBOX_ITEM = ItemRegistry.register("purple_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.PURPLE_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> BLUE_MAILBOX_ITEM = ItemRegistry.register("blue_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.BLUE_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> BROWN_MAILBOX_ITEM = ItemRegistry.register("brown_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.BROWN_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> GREEN_MAILBOX_ITEM = ItemRegistry.register("green_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.GREEN_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> RED_MAILBOX_ITEM = ItemRegistry.register("red_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.RED_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> BLACK_MAILBOX_ITEM = ItemRegistry.register("black_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.BLACK_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> CENTER_MAILBOX_ITEM = ItemRegistry.register("center_mailbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.CENTER_MAILBOX.get()));
    public static final RegistrySupplier<BlockItem> RED_POSTBOX_ITEM = ItemRegistry.register("red_postbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.RED_POSTBOX.get()));
    public static final RegistrySupplier<BlockItem> GREEN_POSTBOX_ITEM = ItemRegistry.register("green_postbox", () -> ItemRegistry.createBlockItem((Block)BlockRegistry.GREEN_POSTBOX.get()));

    private static <T extends Item> RegistrySupplier<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static BlockItem createBlockItem(Block block) {
        if (block instanceof ISilveroakEntry) {
            ISilveroakEntry b = (ISilveroakEntry)block;
            return new NormalBlockItem(block, b.getRegistryID(), Contact.ITEM_GROUP);
        }
        return new BlockItem(block, new Item.Properties());
    }

    public static void initItems() {
    }

    public static void initPostcardStyles(CreativeModeTab.ItemDisplayParameters displayContext, CreativeModeTab.Output entries) {
        for (ResourceLocation id : PostcardDataManager.getPostcards().keySet()) {
            entries.accept(PostcardItem.getPostcard(id, false));
        }
        for (ResourceLocation id : PostcardDataManager.getPostcards().keySet()) {
            entries.accept(PostcardItem.getPostcard(id, true));
        }
    }
}

