/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.item;

import com.flechazo.contact.Contact;
import com.flechazo.contact.client.item.PackageTooltipData;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.NormalItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ParcelItem
extends NormalItem
implements IMailItem,
IPackageItem {
    private final boolean isEnderType;

    public ParcelItem(String id, boolean isEnderType) {
        super(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)id), new Item.Properties().stacksTo(1), Contact.ITEM_GROUP);
        this.isEnderType = isEnderType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        IPackageItem.openPackage(this, user, hand);
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        PackageTooltipData data = IPackageItem.getTooltipData(this, stack);
        return data.contents().isEmpty() ? Optional.empty() : Optional.of(data);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        this.addSenderInfoTooltip(stack, tooltipContext, tooltip, flag);
    }

    @Override
    public boolean isEnderType() {
        return this.isEnderType;
    }

    public static ItemStack getParcel(SimpleContainer contents, boolean isEnderType, String sender) {
        ItemStack parcel = new ItemStack(isEnderType ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get());
        parcel.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)contents.getItems()));
        if (!sender.isEmpty()) {
            parcel.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
        }
        return parcel;
    }

    @Override
    public int getCapacity() {
        return 4;
    }
}

