/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.item;

import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.entity.PostcardEntity;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.item.NormalItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class PostcardItem
extends NormalItem
implements IMailItem {
    private final boolean isEnderType;

    public PostcardItem(String id, boolean isEnderType) {
        super(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)id), new Item.Properties().stacksTo(1), null);
        this.isEnderType = isEnderType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (level.isClientSide) {
            if (itemstack.has((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get())) {
                ClientProxy.openPostcardToRead(itemstack);
            } else {
                ClientProxy.openPostcardToEdit(itemstack, user, hand);
            }
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level;
        PostcardEntity postcardEntity;
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockPos blockPos2 = blockPos.relative(direction);
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (player != null) {
            if (!player.isShiftKeyDown()) {
                return InteractionResult.PASS;
            }
            if (!this.canPlaceOn(player, direction, itemStack, blockPos2)) {
                return InteractionResult.FAIL;
            }
        }
        if ((postcardEntity = new PostcardEntity(level = context.getLevel(), blockPos2, direction)).survives()) {
            if (!level.isClientSide) {
                postcardEntity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, postcardEntity.getPos());
                level.addFreshEntity((Entity)postcardEntity);
                postcardEntity.setHeldItemStack(itemStack.copy());
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean canPlaceOn(Player player, Direction side, ItemStack stack, BlockPos pos) {
        return !player.level().isOutsideBuildHeight(pos) && player.mayUseItemAt(pos, side, stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        ResourceLocation styleId = (ResourceLocation)stack.get((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get());
        if (styleId != null) {
            MutableComponent background = Component.translatable((String)("tooltip.postcard." + styleId.getNamespace() + "." + styleId.getPath())).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)Component.translatable((String)"tooltip.contact.postcard.background", (Object[])new Object[]{background}).withStyle(ChatFormatting.GRAY));
        }
        this.addSenderInfoTooltip(stack, tooltipContext, tooltip, flag);
    }

    @Override
    public boolean isEnderType() {
        return this.isEnderType;
    }

    public static ItemStack getPostcard(ResourceLocation id, boolean isEnderType) {
        ItemStack postcard = new ItemStack(isEnderType ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get());
        postcard.set((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get(), (Object)id);
        return postcard;
    }

    public static ItemStack setText(ItemStack postcard, String text) {
        postcard.set((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)text);
        return postcard;
    }

    public static String getText(ItemStack postcard) {
        return (String)postcard.getOrDefault((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)"");
    }
}

