/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.screenhandler;

import com.flechazo.contact.common.screenhandler.ContentScreenHandler;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public abstract class PackageScreenHandler
extends ContentScreenHandler {
    public boolean isPacked = false;
    public boolean droppedPaper = false;

    public PackageScreenHandler(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    public abstract SimpleContainer getContainer();

    public abstract ItemStack getUnpackedItem();

    public abstract ItemStack getPackedItem();

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            if (!this.isPacked) {
                if (!player.isAlive() || ((ServerPlayer)player).hasDisconnected()) {
                    for (int j = 0; j < this.getContainerCount(); ++j) {
                        player.drop(this.getContainer().getItem(j), false);
                        this.getContainer().setItem(j, ItemStack.EMPTY);
                    }
                    ItemStack cursor = this.getCarried();
                    if (!cursor.isEmpty()) {
                        player.drop(cursor, false);
                    }
                    if (!player.getAbilities().instabuild && !this.droppedPaper) {
                        player.drop(this.getUnpackedItem(), false);
                        this.droppedPaper = true;
                    }
                } else {
                    for (int i = 0; i < this.getContainerCount(); ++i) {
                        player.getInventory().placeItemBackInInventory(this.getContainer().getItem(i));
                        this.getContainer().setItem(i, ItemStack.EMPTY);
                    }
                    ItemStack cursor = this.getCarried();
                    if (!cursor.isEmpty()) {
                        player.getInventory().placeItemBackInInventory(cursor);
                    }
                    if (!player.getAbilities().instabuild && !this.droppedPaper) {
                        player.getInventory().placeItemBackInInventory(this.getUnpackedItem());
                        this.droppedPaper = true;
                    }
                }
            } else {
                ItemStack parcel = this.getPackedItem();
                parcel.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.getContainer().getItems()));
                if (!player.isAlive() || ((ServerPlayer)player).hasDisconnected()) {
                    player.drop(parcel, false);
                } else {
                    player.getInventory().placeItemBackInInventory(parcel);
                }
            }
        }
    }
}

