/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.screenhandler;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.IMailItem;
import com.flechazo.contact.common.screenhandler.ContentScreenHandler;
import com.flechazo.contact.common.screenhandler.ScreenHandlerTypeRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PostboxScreenHandler
extends ContentScreenHandler {
    public final SimpleContainer parcel = new SimpleContainer(1);
    public byte status = 0;
    public String playerName = "";
    public List<String> names = Lists.newArrayList();
    public List<Integer> ticks = Lists.newArrayList();
    private final boolean isRed;

    public PostboxScreenHandler(int id, Inventory inv, boolean isRed) {
        super(isRed ? (MenuType)ScreenHandlerTypeRegistry.RED_POSTBOX_CONTAINER.get() : (MenuType)ScreenHandlerTypeRegistry.GREEN_POSTBOX_CONTAINER.get(), id);
        int i;
        this.isRed = isRed;
        this.parcel.addListener(inventory -> {
            if (this.parcel.getItem(0).getItem() instanceof IMailItem) {
                String sender = (String)this.parcel.getItem(0).get((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get());
                this.status = sender == null || sender.isEmpty() ? (byte)1 : (byte)3;
            } else if (this.status != 2) {
                this.status = 0;
            }
        });
        this.addSlot(new Slot(this, (Container)this.parcel, 0, 16, 33){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof IMailItem;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 67 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 125));
        }
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            if (!player.isAlive() || ((ServerPlayer)player).hasDisconnected()) {
                player.drop(this.parcel.getItem(0), false);
                ItemStack cursor = this.getCarried();
                if (!cursor.isEmpty()) {
                    player.drop(cursor, false);
                }
            } else {
                player.getInventory().placeItemBackInInventory(this.parcel.getItem(0));
                ItemStack cursor = this.getCarried();
                if (!cursor.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(cursor);
                }
            }
            this.parcel.setItem(0, ItemStack.EMPTY);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean isEnderMail() {
        Item mail = this.parcel.getItem(0).getItem();
        return mail instanceof IMailItem && ((IMailItem)mail).isEnderType();
    }

    @Override
    public int getContainerCount() {
        return 1;
    }

    public boolean isRed() {
        return this.isRed;
    }
}

