/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.screenhandler;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.ItemRegistry;
import com.flechazo.contact.common.screenhandler.PackageScreenHandler;
import com.flechazo.contact.common.screenhandler.ScreenHandlerTypeRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RedPacketEnvelopeScreenHandler
extends PackageScreenHandler {
    public static final int CONTENT_COUNT = 1;
    public final SimpleContainer inputs = new SimpleContainer(1);
    public String blessings = "";

    public RedPacketEnvelopeScreenHandler(int id, Container container) {
        super((MenuType)ScreenHandlerTypeRegistry.RED_PACKET_ENVELOPE_CONTAINER.get(), id);
        int i;
        this.addSlot(new Slot(this, (Container)this.inputs, 0, 40, 34){

            public boolean mayPlace(ItemStack stack) {
                if (stack.getItem() instanceof IPackageItem) {
                    return false;
                }
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                return !ContactCommonConfig.getBlacklistID().contains(id.toString()) && !ContactCommonConfig.getBlacklistID().contains(id.getPath());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot(container, j + i * 9 + 9, 8 + j * 18, 67 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(container, i, 8 + i * 18, 125));
        }
    }

    @Override
    public SimpleContainer getContainer() {
        return this.inputs;
    }

    @Override
    public ItemStack getUnpackedItem() {
        return new ItemStack((ItemLike)ItemRegistry.RED_PACKET_ENVELOPE.get());
    }

    @Override
    public ItemStack getPackedItem() {
        ItemStack redPacket = new ItemStack((ItemLike)ItemRegistry.RED_PACKET.get());
        if (!this.blessings.isBlank()) {
            redPacket.set((DataComponentType)ContactDataComponents.RED_PACKET_BLESSING.get(), (Object)this.blessings);
        }
        return redPacket;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public int getContainerCount() {
        return 1;
    }
}

