/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.screenhandler;

import com.flechazo.contact.client.gui.screen.EnvelopeScreen;
import com.flechazo.contact.client.gui.screen.PostboxScreen;
import com.flechazo.contact.client.gui.screen.RedPacketEnvelopeScreen;
import com.flechazo.contact.client.gui.screen.WrappingPaperScreen;
import com.flechazo.contact.common.screenhandler.EnvelopeScreenHandler;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.screenhandler.RedPacketEnvelopeScreenHandler;
import com.flechazo.contact.common.screenhandler.WrappingPaperScreenHandler;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public final class ScreenHandlerTypeRegistry {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((String)"contact", (ResourceKey)Registries.MENU);
    public static final RegistrySupplier<MenuType<WrappingPaperScreenHandler>> WRAPPING_PAPER_CONTAINER = ScreenHandlerTypeRegistry.register("wrapping_paper", () -> MenuRegistry.ofExtended((id, inv, buf) -> new WrappingPaperScreenHandler(id, (Container)inv, false)));
    public static final RegistrySupplier<MenuType<EnvelopeScreenHandler>> ENVELOPE_CONTAINER = ScreenHandlerTypeRegistry.register("envelope", () -> new MenuType(EnvelopeScreenHandler::new, FeatureFlags.VANILLA_SET));
    public static final RegistrySupplier<MenuType<RedPacketEnvelopeScreenHandler>> RED_PACKET_ENVELOPE_CONTAINER = ScreenHandlerTypeRegistry.register("red_packet_envelope", () -> new MenuType(RedPacketEnvelopeScreenHandler::new, FeatureFlags.VANILLA_SET));
    public static final RegistrySupplier<MenuType<PostboxScreenHandler>> RED_POSTBOX_CONTAINER = ScreenHandlerTypeRegistry.register("red_postbox", () -> MenuRegistry.ofExtended((id, inv, buf) -> {
        boolean isRed = buf.readBoolean();
        return new PostboxScreenHandler(id, inv, isRed);
    }));
    public static final RegistrySupplier<MenuType<PostboxScreenHandler>> GREEN_POSTBOX_CONTAINER = ScreenHandlerTypeRegistry.register("green_postbox", () -> MenuRegistry.ofExtended((id, inv, buf) -> {
        boolean isRed = buf.readBoolean();
        return new PostboxScreenHandler(id, inv, isRed);
    }));

    private static <C extends AbstractContainerMenu> RegistrySupplier<MenuType<C>> register(String name, Supplier<MenuType<C>> menu) {
        return MENU_TYPES.register(name, menu);
    }

    public static void registerContainers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)WRAPPING_PAPER_CONTAINER.get()), WrappingPaperScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ENVELOPE_CONTAINER.get()), EnvelopeScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)RED_PACKET_ENVELOPE_CONTAINER.get()), RedPacketEnvelopeScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)RED_POSTBOX_CONTAINER.get()), PostboxScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)GREEN_POSTBOX_CONTAINER.get()), PostboxScreen::new);
    }
}

