/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.storage;

import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class MailToBeSent {
    private final UUID uuid;
    private final SimpleContainer contents;
    private long ticks;

    public MailToBeSent(CompoundTag tag, HolderLookup.Provider provider) {
        this.uuid = UUID.fromString(tag.getString("MailUUID"));
        this.ticks = tag.getInt("MailTicks");
        this.contents = new SimpleContainer(1);
        this.contents.fromTag(tag.getList("MailContents", 10), provider);
    }

    public MailToBeSent(UUID uuid, ItemStack contents, long ticks) {
        this.uuid = uuid;
        this.contents = new SimpleContainer(1);
        this.contents.setItem(0, contents.copy());
        this.ticks = ticks;
    }

    public ItemStack getContents() {
        return this.contents.getItem(0).copy();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReady() {
        return this.ticks <= 0L;
    }

    public void tick(int tick) {
        if (this.ticks > 0L) {
            this.ticks -= (long)tick;
        }
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("MailUUID", this.uuid.toString());
        nbt.putLong("MailTicks", this.ticks);
        nbt.put("MailContents", (Tag)this.contents.createTag(provider));
        return nbt;
    }
}

