/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.storage;

import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.network.ActionS2CMessage;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerMailboxData {
    public final Map<String, UUID> nameToUUID = Maps.newTreeMap();
    public final Map<UUID, SimpleContainer> uuidToContents = Maps.newHashMap();
    private final Map<UUID, GlobalPos> uuidToLocation = Maps.newHashMap();
    private final Map<GlobalPos, UUID> locationToPlayer = Maps.newHashMap();
    public final List<MailToBeSent> mailList = Lists.newArrayList();
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerMailboxData> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        CompoundTag tag = new CompoundTag();
        data.writeToNBT(tag, (HolderLookup.Provider)buf.registryAccess());
        ByteBufCodecs.COMPOUND_TAG.encode(buf, (Object)tag);
        buf.writeInt(data.nameToUUID.size());
        data.nameToUUID.forEach((name, uuid) -> {
            ByteBufCodecs.STRING_UTF8.encode(buf, name);
            ByteBufCodecs.STRING_UTF8.encode(buf, (Object)uuid.toString());
        });
    }, buf -> {
        PlayerMailboxData data = new PlayerMailboxData();
        CompoundTag tag = (CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(buf);
        data.readFromNBT(tag, (HolderLookup.Provider)buf.registryAccess());
        int nameMapSize = buf.readInt();
        for (int i = 0; i < nameMapSize; ++i) {
            String name = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
            String uuidStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
            data.nameToUUID.put(name, UUID.fromString(uuidStr));
        }
        return data;
    });

    public CompoundTag serializeForAttachment(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.writeToNBT(tag, provider);
        return tag;
    }

    public static PlayerMailboxData deserializeForAttachment(CompoundTag tag, HolderLookup.Provider provider) {
        PlayerMailboxData data = new PlayerMailboxData();
        data.readFromNBT(tag, provider);
        return data;
    }

    public SimpleContainer getMailboxContents(UUID uuid) {
        return this.uuidToContents.getOrDefault(uuid, new SimpleContainer(24));
    }

    public boolean isMailboxEmpty(UUID uuid) {
        SimpleContainer contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return true;
        }
        for (int i = 0; i < contents.getContainerSize(); ++i) {
            if (contents.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isMailboxFull(UUID uuid) {
        SimpleContainer contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return false;
        }
        for (int i = 0; i < contents.getContainerSize(); ++i) {
            if (!contents.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean addMailboxContents(UUID uuid, ItemStack parcelIn) {
        SimpleContainer mailbox = this.getMailboxContents(uuid);
        if (!this.isMailboxFull(uuid)) {
            for (int i = 0; i < mailbox.getContainerSize(); ++i) {
                if (!mailbox.getItem(i).isEmpty()) continue;
                mailbox.setItem(i, parcelIn);
                this.setMailboxContents(uuid, mailbox);
                ServerPlayer player = PlatformHelper.getCurrentServer().getPlayerList().getPlayer(uuid);
                if (player != null) {
                    ActionS2CMessage packet = ActionS2CMessage.create(0);
                    packet.sendTo(player);
                }
                return true;
            }
        }
        return false;
    }

    public void setMailboxContents(UUID uuid, SimpleContainer contents) {
        this.uuidToContents.put(uuid, contents);
    }

    public void resetMailboxContents(UUID uuid) {
        this.setMailboxContents(uuid, new SimpleContainer(24));
    }

    @Nullable
    public UUID getMailboxOwner(ResourceKey<Level> level, BlockPos pos) {
        return this.locationToPlayer.get(GlobalPos.of(level, (BlockPos)pos));
    }

    @Nullable
    public GlobalPos getMailboxPos(UUID uuid) {
        return this.uuidToLocation.get(uuid);
    }

    public void setMailboxData(UUID uuid, ResourceKey<Level> level, BlockPos pos) {
        BlockEntity newTE;
        GlobalPos newPos = GlobalPos.of(level, (BlockPos)pos);
        GlobalPos oldPos = this.uuidToLocation.get(uuid);
        if (oldPos != null) {
            BlockEntity oldTE;
            this.locationToPlayer.remove(oldPos);
            ServerLevel oldLevel = PlatformHelper.getCurrentServer().getLevel(oldPos.dimension());
            if (oldLevel != null && oldLevel.hasChunkAt(oldPos.pos()) && (oldTE = oldLevel.getBlockEntity(oldPos.pos())) instanceof MailboxBlockEntity) {
                ((MailboxBlockEntity)oldTE).refreshStatus();
            }
        }
        this.uuidToLocation.put(uuid, newPos);
        this.locationToPlayer.put(newPos, uuid);
        ServerLevel newWorld = PlatformHelper.getCurrentServer().getLevel(level);
        if (newWorld != null && newWorld.hasChunkAt(newPos.pos()) && (newTE = newWorld.getBlockEntity(newPos.pos())) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)newTE).refreshStatus();
        }
    }

    public void removeMailboxData(GlobalPos pos) {
        GlobalPos mailboxPos;
        UUID uuid = this.locationToPlayer.remove(pos);
        if (uuid != null && Objects.equals(mailboxPos = this.uuidToLocation.get(uuid), pos)) {
            this.uuidToLocation.remove(uuid);
        }
    }

    public CompoundTag writeToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        int n = this.uuidToContents.size();
        tag.putInt("MapDataSize", n);
        int i = 0;
        for (UUID uuid : this.uuidToContents.keySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("UUID", uuid.toString());
            compoundTag.put("Contents", (Tag)this.uuidToContents.getOrDefault(uuid, new SimpleContainer(24)).createTag(provider));
            GlobalPos globalPos = this.uuidToLocation.get(uuid);
            if (globalPos != null) {
                ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)globalPos.dimension().location()).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).ifPresent(world -> compoundTag.put("MailboxDimension", world));
                compoundTag.putInt("MailboxX", globalPos.pos().getX());
                compoundTag.putInt("MailboxY", globalPos.pos().getY());
                compoundTag.putInt("MailboxZ", globalPos.pos().getZ());
            }
            tag.put("MapData" + i, (Tag)compoundTag);
            ++i;
        }
        tag.putInt("MailListSize", this.mailList.size());
        for (i = 0; i < this.mailList.size(); ++i) {
            tag.put("MailListData" + i, (Tag)this.mailList.get(i).writeToNBT(provider));
        }
        tag.putInt("NameMapSize", this.nameToUUID.size());
        i = 0;
        for (String name : this.nameToUUID.keySet()) {
            tag.putString("NameMap" + i, name);
            tag.putString("NameMapUUID" + i, this.nameToUUID.get(name).toString());
            ++i;
        }
        return tag;
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        UUID uuid;
        CompoundTag compoundTag;
        int i;
        this.uuidToContents.clear();
        this.uuidToLocation.clear();
        this.locationToPlayer.clear();
        this.mailList.clear();
        this.nameToUUID.clear();
        int n = tag.getInt("MapDataSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.getCompound("MapData" + i);
            uuid = UUID.fromString(compoundTag.getString("UUID"));
            SimpleContainer contents = new SimpleContainer(24);
            contents.fromTag(compoundTag.getList("Contents", 10), provider);
            this.uuidToContents.put(uuid, contents);
            if (!compoundTag.contains("MailboxDimension")) continue;
            BlockPos mailboxPos = new BlockPos(compoundTag.getInt("MailboxX"), compoundTag.getInt("MailboxY"), compoundTag.getInt("MailboxZ"));
            ResourceKey mailboxWorld = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("MailboxDimension")).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).orElse(Level.OVERWORLD);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)mailboxWorld, (BlockPos)mailboxPos);
            this.uuidToLocation.put(uuid, globalPos);
            this.locationToPlayer.put(globalPos, uuid);
        }
        n = tag.getInt("MailListSize");
        for (i = 0; i < n; ++i) {
            compoundTag = tag.getCompound("MailListData" + i);
            MailToBeSent mail = new MailToBeSent(compoundTag, provider);
            this.mailList.add(mail);
        }
        n = tag.getInt("NameMapSize");
        for (i = 0; i < n; ++i) {
            String name = tag.getString("NameMap" + i);
            uuid = UUID.fromString(tag.getString("NameMapUUID" + i));
            this.nameToUUID.put(name, uuid);
        }
    }
}

