/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.tileentity;

import com.flechazo.contact.common.block.MailboxBlock;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.tileentity.BlockEntityTypeRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends BlockEntity {
    private boolean isOpened = false;
    private boolean needRefresh = false;
    private int refreshTicks = 20;
    private int checkToSendTicks = 0;
    private int angel = 0;

    public MailboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.isOpened = nbt.getBoolean("IsOpened");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putBoolean("IsOpened", this.isOpened);
    }

    public boolean checkToSend() {
        if (this.checkToSendTicks <= 0) {
            this.checkToSendTicks = 60;
            return false;
        }
        return true;
    }

    public void refreshStatus() {
        if (!this.level.isClientSide) {
            boolean now;
            IMailboxDataProvider data = MailboxDataManager.getData(this.level);
            boolean bl = now = !data.isMailboxEmpty(data.getMailboxOwner((ResourceKey<Level>)this.level.dimension(), this.getBlockPos()));
            if (now != this.isOpened) {
                this.needRefresh = true;
                this.isOpened = now;
                this.refresh();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MailboxBlockEntity blockEntity) {
        if (!level.isClientSide) {
            if (blockEntity.refreshTicks >= 0) {
                --blockEntity.refreshTicks;
            }
            if (blockEntity.checkToSendTicks > 0) {
                --blockEntity.checkToSendTicks;
            }
            if (blockEntity.needRefresh || blockEntity.refreshTicks == 0) {
                blockEntity.refreshStatus();
                BlockState down = level.getBlockState(pos.below());
                if (!(down.getBlock() instanceof MailboxBlock) || (Boolean)down.getValue((Property)MailboxBlock.OPEN) == blockEntity.isOpened) {
                    blockEntity.needRefresh = false;
                    return;
                }
                level.setBlockAndUpdate(pos.below(), (BlockState)down.setValue((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                blockEntity.needRefresh = false;
                if (state.getBlock() instanceof MailboxBlock) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(blockEntity.isOpened)));
                }
            }
        } else if (blockEntity.isOpened) {
            ++blockEntity.angel;
            blockEntity.angel %= 40;
        }
    }

    private void refresh() {
        if (this.hasLevel() && !this.level.isClientSide) {
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
            List players = ((ServerLevel)this.level).getChunkSource().chunkMap.getPlayers(new ChunkPos(this.getBlockPos().getX() >> 4, this.getBlockPos().getZ() >> 4), false);
            for (ServerPlayer player : players) {
                player.connection.send((Packet)packet);
            }
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public int getAngel() {
        return this.angel;
    }
}

