/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.helper;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class GuiHelper {
    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder wr = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = poseStack.last().pose();
        wr.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)u * 0.00390625f, (float)(v + height) * 0.00390625f);
        wr.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f);
        wr.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * 0.00390625f, (float)v * 0.00390625f);
        wr.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)u * 0.00390625f, (float)v * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)wr.buildOrThrow());
    }

    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos, int z) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), z);
    }

    public static void drawLayer(PoseStack poseStack, int x, int y, TexturePos pos) {
        GuiHelper.drawTexturedModalRect(poseStack, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight(), 0.0f);
    }

    public static void drawLayer(GuiGraphics guiGraphics, int x, int y, ResourceLocation rl, TexturePos pos) {
        guiGraphics.blit(rl, x, y, pos.getX(), pos.getY(), pos.getWidth(), pos.getHeight());
    }

    public static void drawLayerBySize(GuiGraphics guiGraphics, ResourceLocation rl, int x, int y, TexturePos pos, int textureWidth, int textureHeight) {
        guiGraphics.blit(rl, x, y, pos.getWidth(), pos.getHeight(), (float)pos.getX(), (float)pos.getY(), pos.getWidth(), pos.getHeight(), textureWidth, textureHeight);
    }

    public static void drawLayerBySize(GuiGraphics guiGraphics, ResourceLocation rl, int x, int y, TexturePos pos) {
        GuiHelper.drawLayerBySize(guiGraphics, rl, x, y, pos, pos.getWidth(), pos.getHeight());
    }

    public static void renderIconButton(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, IconButton button, TexturePos normalPos, TexturePos hoveredPos, TexturePos pressedPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        if (button.isPressed()) {
            GuiHelper.drawLayer(guiGraphics.pose(), button.getX(), button.getY(), pressedPos);
            RenderSystem.disableBlend();
            return;
        }
        if (button.isHovered()) {
            GuiHelper.drawLayer(guiGraphics.pose(), button.getX(), button.getY(), hoveredPos);
            RenderSystem.disableBlend();
            return;
        }
        GuiHelper.drawLayer(guiGraphics.pose(), button.getX(), button.getY(), normalPos);
        RenderSystem.disableBlend();
        button.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void renderButton(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, int z, ResourceLocation texture, Button button, TexturePos normalPos, TexturePos hoveredPos) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        if (button.isHovered()) {
            GuiHelper.drawLayer(guiGraphics.pose(), button.getX(), button.getY(), hoveredPos);
        } else {
            GuiHelper.drawLayer(guiGraphics.pose(), button.getX(), button.getY(), normalPos);
        }
        RenderSystem.disableBlend();
        button.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int weight, int height, List<Component> list) {
        if (x <= mouseX && mouseX <= x + weight && y <= mouseY && mouseY <= y + height) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, list, Optional.empty(), mouseX, mouseY);
        }
    }
}

