/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.neoforge.attachment;

import com.flechazo.contact.common.storage.PlayerMailboxData;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ContactAttachments {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"contact");
    public static final Supplier<AttachmentType<PlayerMailboxData>> MAILBOX_DATA = ATTACHMENT_TYPES.register("mailbox_data", () -> AttachmentType.builder(PlayerMailboxData::new).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, PlayerMailboxData>(){

        public PlayerMailboxData read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            return PlayerMailboxData.deserializeForAttachment(tag, provider);
        }

        public CompoundTag write(PlayerMailboxData attachment, HolderLookup.Provider provider) {
            return attachment.serializeForAttachment(provider);
        }
    }).copyOnDeath().sync((holder, player) -> {
        ServerPlayer sp;
        return holder instanceof ServerPlayer && (sp = (ServerPlayer)holder).equals(player);
    }, PlayerMailboxData.STREAM_CODEC).build());
}

