/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.neoforge.attachment;

import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.PlayerMailboxData;
import com.flechazo.contact.neoforge.attachment.ContactAttachments;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record NeoForgeMailboxDataProvider(ServerLevel level) implements IMailboxDataProvider
{
    private PlayerMailboxData getData() {
        return (PlayerMailboxData)this.level.getData(ContactAttachments.MAILBOX_DATA);
    }

    @Override
    public PlayerMailboxData data() {
        return this.getData();
    }

    @Override
    public Map<String, UUID> getNameToUUID() {
        return this.getData().nameToUUID;
    }

    @Override
    public Map<UUID, SimpleContainer> getUuidToContents() {
        return this.getData().uuidToContents;
    }

    @Override
    public List<MailToBeSent> getMailList() {
        return this.getData().mailList;
    }

    @Override
    public SimpleContainer getMailboxContents(UUID uuid) {
        return this.getData().getMailboxContents(uuid);
    }

    @Override
    public boolean isMailboxEmpty(UUID uuid) {
        return this.getData().isMailboxEmpty(uuid);
    }

    @Override
    public boolean isMailboxFull(UUID uuid) {
        return this.getData().isMailboxFull(uuid);
    }

    @Override
    public boolean addMailboxContents(UUID uuid, ItemStack parcelIn) {
        return this.getData().addMailboxContents(uuid, parcelIn);
    }

    @Override
    public void setMailboxContents(UUID uuid, SimpleContainer contents) {
        this.getData().setMailboxContents(uuid, contents);
    }

    @Override
    public void resetMailboxContents(UUID uuid) {
        this.getData().resetMailboxContents(uuid);
    }

    @Override
    @Nullable
    public UUID getMailboxOwner(ResourceKey<Level> level, BlockPos pos) {
        return this.getData().getMailboxOwner(level, pos);
    }

    @Override
    @Nullable
    public GlobalPos getMailboxPos(UUID uuid) {
        return this.getData().getMailboxPos(uuid);
    }

    @Override
    public void setMailboxData(UUID uuid, ResourceKey<Level> level, BlockPos pos) {
        this.getData().setMailboxData(uuid, level, pos);
    }

    @Override
    public void removeMailboxData(GlobalPos pos) {
        this.getData().removeMailboxData(pos);
    }
}

