/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record AddresseeDataMessage(List<String> names, List<Integer> ticks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AddresseeDataMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"addressee_data_message"));
    public static final StreamCodec<FriendlyByteBuf, AddresseeDataMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), AddresseeDataMessage::names, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), AddresseeDataMessage::ticks, AddresseeDataMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleClient() {
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        client.execute(() -> {
            AbstractContainerMenu patt0$temp = client.player.containerMenu;
            if (patt0$temp instanceof PostboxScreenHandler) {
                PostboxScreenHandler container = (PostboxScreenHandler)patt0$temp;
                container.names = this.names;
                container.ticks = this.ticks;
            }
        });
    }

    public static AddresseeDataMessage create(List<String> names, List<Integer> ticks) {
        return new AddresseeDataMessage(names, ticks);
    }

    public void sendTo(ServerPlayer player) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this);
    }
}

