/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.network.ActionS2CMessage;
import com.flechazo.contact.network.AddresseeDataMessage;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record EnquireAddresseeMessage(String nameIn, boolean shouldSend) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnquireAddresseeMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"enquire_addressee_message"));
    public static final StreamCodec<FriendlyByteBuf, EnquireAddresseeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, EnquireAddresseeMessage::nameIn, (StreamCodec)ByteBufCodecs.BOOL, EnquireAddresseeMessage::shouldSend, EnquireAddresseeMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleServer(ServerPlayer player) {
        if (player == null || this.nameIn.isEmpty()) {
            return;
        }
        IMailboxDataProvider data = MailboxDataManager.getData(player.server);
        String lowerIn = this.nameIn.toLowerCase(Locale.ROOT);
        if (lowerIn.equals("@e") && player.server.getProfilePermissions(player.getGameProfile()) >= 2) {
            this.handleAdminBroadcast(player, data);
            return;
        }
        this.handleNormalEnquiry(player, data, lowerIn);
    }

    private void handleAdminBroadcast(ServerPlayer player, IMailboxDataProvider data) {
        if (this.shouldSend) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof PostboxScreenHandler) {
                PostboxScreenHandler container = (PostboxScreenHandler)abstractContainerMenu;
                ItemStack parcel = container.parcel.getItem(0).copy();
                parcel.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)player.getName().getString());
                for (UUID uuid : data.getNameToUUID().values()) {
                    data.getMailList().add(new MailToBeSent(uuid, parcel.copy(), 0L));
                }
                ActionS2CMessage.create(1).sendTo(player);
                container.parcel.setItem(0, ItemStack.EMPTY);
            }
        } else {
            ArrayList<String> names = new ArrayList<String>();
            names.add("@e");
            ArrayList<Integer> ticks = new ArrayList<Integer>();
            ticks.add(0);
            AddresseeDataMessage.create(names, ticks).sendTo(player);
        }
    }

    private void handleNormalEnquiry(ServerPlayer player, IMailboxDataProvider data, String lowerIn) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : data.getNameToUUID().keySet()) {
            if (name.toLowerCase(Locale.ROOT).startsWith(lowerIn)) {
                names.add(name);
            }
            if (names.size() != 4) continue;
            break;
        }
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (String name : names) {
            UUID uuid = data.getNameToUUID().get(name);
            if (data.isMailboxFull(uuid)) {
                ticks.add(-1);
                continue;
            }
            GlobalPos mailboxPos = data.getMailboxPos(uuid);
            if (!(player.containerMenu instanceof PostboxScreenHandler)) continue;
            int tick = 0;
            if (!((PostboxScreenHandler)player.containerMenu).isEnderMail()) {
                tick = mailboxPos != null ? MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.level().dimension(), player.blockPosition(), (ResourceKey<Level>)mailboxPos.dimension(), mailboxPos.pos()) : (ContactCommonConfig.isEnableCenterMailbox() ? MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.level().dimension(), player.blockPosition(), (ResourceKey<Level>)Level.OVERWORLD, player.level().getSharedSpawnPos()) : -2);
            }
            ticks.add(tick);
        }
        if (player.containerMenu instanceof PostboxScreenHandler) {
            if (this.shouldSend && !names.isEmpty() && Objects.equals(names.getFirst(), this.nameIn) && (Integer)ticks.getFirst() >= 0) {
                this.handleSendMail(player, data, (String)names.getFirst(), (Integer)ticks.getFirst());
            } else {
                AddresseeDataMessage.create(names, ticks).sendTo(player);
            }
        }
    }

    private void handleSendMail(ServerPlayer player, IMailboxDataProvider data, String recipientName, int deliveryTicks) {
        UUID uuid;
        GlobalPos mailboxPos;
        PostboxScreenHandler container = (PostboxScreenHandler)player.containerMenu;
        ItemStack parcel = container.parcel.getItem(0);
        parcel.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)player.getName().getString());
        if (IPackageItem.checkAndPostmarkPostcard(parcel, player.getName().getString()) || parcel.getItem() instanceof PostcardItem) {
            AdvancementManager.givePlayerAdvancement(player.server, player, ResourceLocation.parse((String)"contact:send_postcard"));
        }
        if ((mailboxPos = data.getMailboxPos(uuid = data.getNameToUUID().get(recipientName))) != null) {
            if (mailboxPos.dimension() != player.level().dimension()) {
                parcel.set((DataComponentType)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
            }
        } else if (Level.OVERWORLD != player.level().dimension()) {
            parcel.set((DataComponentType)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
        }
        data.getMailList().add(new MailToBeSent(uuid, parcel, deliveryTicks));
        ActionS2CMessage.create(1).sendTo(player);
        container.parcel.setItem(0, ItemStack.EMPTY);
    }

    public static EnquireAddresseeMessage create(String name, boolean shouldSend) {
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void sendToServer() {
        NetworkManager.sendToServer((CustomPacketPayload)this);
    }
}

