/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.PostcardItem;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public record PostcardEditMessage(ItemStack postcard, int held) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PostcardEditMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"postcard_edit_message"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PostcardEditMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, PostcardEditMessage::postcard, (StreamCodec)ByteBufCodecs.VAR_INT, PostcardEditMessage::held, PostcardEditMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleServer(ServerPlayer player) {
        ItemStack card;
        if (player == null) {
            return;
        }
        if (this.postcard.getItem() instanceof PostcardItem && (Inventory.isHotbarSlot((int)this.held) || this.held == 40) && (card = player.getInventory().getItem(this.held)).getItem() instanceof PostcardItem) {
            String text = (String)this.postcard.get((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get());
            ResourceLocation styleId = (ResourceLocation)this.postcard.get((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get());
            String sender = (String)this.postcard.get((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get());
            if (text != null) {
                card.set((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)text);
            }
            if (styleId != null) {
                card.set((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get(), (Object)styleId);
            }
            if (sender != null) {
                card.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)sender);
            }
        }
    }

    public static PostcardEditMessage create(ItemStack postcard, int held) {
        return new PostcardEditMessage(postcard, held);
    }

    public void sendToServer() {
        NetworkManager.sendToServer((CustomPacketPayload)this);
    }
}

