/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client;

import com.flechazo.contact.client.gui.screen.NewMailToast;
import com.flechazo.contact.client.gui.screen.PostcardEditScreen;
import com.flechazo.contact.client.gui.screen.PostcardReadScreen;
import com.flechazo.contact.common.config.ContactClientConfig;
import com.flechazo.contact.data.PostcardStyle;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_437;

public class ClientProxy {
    private static final Map<PostcardStyle, class_1921> CARD_RENDER_LAYERS = Maps.newHashMap();
    private static final Map<PostcardStyle, class_1921> POSTMARK_RENDER_LAYERS = Maps.newHashMap();

    public static void openPostcardToEdit(class_1799 itemstack, class_1657 playerIn, class_1268 handIn) {
        class_310.method_1551().method_1507((class_437)new PostcardEditScreen(itemstack, playerIn, handIn));
    }

    public static void openPostcardToRead(class_1799 itemstack) {
        class_310.method_1551().method_1507((class_437)new PostcardReadScreen(itemstack));
    }

    public static void notifyNewMail(class_310 client) {
        if (ContactClientConfig.isShowNewMailToast()) {
            client.execute(() -> client.method_1566().method_1999((class_368)new NewMailToast()));
        }
    }

    public static void registerCutoutRenderLayer(Supplier<class_2248> block) {
        PlatformHelper.setRenderLayer(block);
    }

    public static class_1921 getPostcardCardRenderLayer(PostcardStyle style) {
        class_1921 renderLayer = CARD_RENDER_LAYERS.get(style);
        if (renderLayer == null) {
            renderLayer = class_1921.method_23028((class_2960)style.getCardTexture());
            CARD_RENDER_LAYERS.put(style, renderLayer);
            return renderLayer;
        }
        return renderLayer;
    }

    public static class_1921 getPostcardPostmarkRenderLayer(PostcardStyle style) {
        class_1921 renderLayer = POSTMARK_RENDER_LAYERS.get(style);
        if (renderLayer == null) {
            renderLayer = class_1921.method_23028((class_2960)style.getPostmarkTexture());
            POSTMARK_RENDER_LAYERS.put(style, renderLayer);
            return renderLayer;
        }
        return renderLayer;
    }
}

