/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.entity;

import com.flechazo.contact.common.entity.EntityTypeRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8111;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class PostcardEntity
extends class_1530 {
    private static final class_2940<class_1799> ITEM_STACK = class_2945.method_12791(PostcardEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> ROTATION = class_2945.method_12791(PostcardEntity.class, (class_2941)class_2943.field_13327);
    private boolean fixed;
    private static final double WIDTH = 12.0;
    private static final double HEIGHT = 12.0;

    public PostcardEntity(class_1299<? extends class_1530> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PostcardEntity(class_1937 level, class_2338 pos, class_2350 facing) {
        this((class_1299<? extends class_1530>)((class_1299)EntityTypeRegistry.POSTCARD.get()), level, pos, facing);
    }

    public PostcardEntity(class_1299<? extends class_1530> type, class_1937 level, class_2338 pos, class_2350 facing) {
        super(type, level, pos);
        this.method_6892(facing);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ITEM_STACK, (Object)class_1799.field_8037);
        builder.method_56912(ROTATION, (Object)0);
    }

    protected void method_6892(class_2350 facing) {
        Validate.notNull((Object)facing);
        this.field_7099 = facing;
        if (facing.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facing.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    protected class_238 method_59943(class_2338 blockPos, class_2350 direction) {
        double e = (double)blockPos.method_10263() + 0.5 - (double)direction.method_10148() * 0.46875;
        double f = (double)blockPos.method_10264() + 0.5 - (double)direction.method_10164() * 0.46875;
        double g = (double)blockPos.method_10260() + 0.5 - (double)direction.method_10165() * 0.46875;
        double h = 12.0;
        double i = 12.0;
        double j = 12.0;
        class_2350.class_2351 axis = direction.method_10166();
        switch (axis) {
            case field_11048: {
                h = 1.0;
                break;
            }
            case field_11052: {
                i = 1.0;
                break;
            }
            case field_11051: {
                j = 1.0;
            }
        }
        return new class_238(e - (h /= 32.0), f - (i /= 32.0), g - (j /= 32.0), e + h, f + i, g + j);
    }

    public boolean method_6888() {
        if (this.fixed) {
            return true;
        }
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2680 blockState = this.method_37908().method_8320(this.field_51589.method_10093(this.field_7099.method_10153()));
        if (!(blockState.method_51367() || this.field_7099.method_10166().method_10179() && class_2312.method_9999((class_2680)blockState))) {
            return false;
        }
        return this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    public void method_5784(class_1313 moverType, class_243 movement) {
        if (!this.fixed) {
            super.method_5784(moverType, movement);
        }
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
        if (!this.fixed) {
            super.method_5762(deltaX, deltaY, deltaZ);
        }
    }

    public float method_5871() {
        return 0.0f;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.fixed) {
            if (source.method_48793().method_40225(class_8111.field_42347) || source.method_5530()) {
                return super.method_5643(source, amount);
            }
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5640(double distance) {
        double d;
        double d2 = 16.0;
        return distance < d * (d2 *= 64.0 * class_1533.method_5824());
    }

    public void method_6889(@Nullable class_1297 entity) {
        this.method_5783(this.getBreakSound(), 1.0f, 1.0f);
        this.dropPostcard(entity);
    }

    public class_3414 getBreakSound() {
        return class_3417.field_14585;
    }

    public void method_6894() {
        this.method_5783(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public class_3414 getPlaceSound() {
        return class_3417.field_14844;
    }

    private void dropPostcard(@Nullable class_1297 entity) {
        if (this.fixed) {
            return;
        }
        class_1799 postcard = this.getPostcard();
        this.setHeldItemStack(class_1799.field_8037);
        if (!this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7477) {
                return;
            }
        }
        if (!postcard.method_7960()) {
            postcard = postcard.method_7972();
            this.method_5775(postcard);
        }
    }

    public class_1799 getPostcard() {
        return (class_1799)this.method_5841().method_12789(ITEM_STACK);
    }

    public void setHeldItemStack(class_1799 value) {
        if (!value.method_7960()) {
            value = value.method_7972();
            value.method_7939(1);
        }
        this.setAsStackHolder(value);
        this.method_5841().method_12778(ITEM_STACK, (Object)value);
    }

    public void method_5674(class_2940<?> data) {
        if (data.equals(ITEM_STACK)) {
            this.setAsStackHolder(this.getPostcard());
        }
    }

    private void setAsStackHolder(class_1799 stack) {
        if (!stack.method_7960() && stack.method_27319() != this) {
            stack.method_27320((class_1297)this);
        }
        this.method_6895();
    }

    public int getRotation() {
        return (Integer)this.method_5841().method_12789(ROTATION);
    }

    private void setRotation(int value) {
        this.method_5841().method_12778(ROTATION, (Object)(value % 16));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (!this.getPostcard().method_7960()) {
            class_5455 provider = this.method_37908().method_30349();
            tag.method_10566("Item", this.getPostcard().method_57358((class_7225.class_7874)provider));
            tag.method_10567("ItemRotation", (byte)this.getRotation());
        }
        tag.method_10567("Facing", (byte)this.field_7099.method_10146());
        tag.method_10556("Invisible", this.method_5767());
        tag.method_10556("Fixed", this.fixed);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        class_2487 compoundTag = tag.method_10562("Item");
        if (!compoundTag.method_33133()) {
            class_5455 provider = this.method_37908().method_30349();
            class_1799 postcard = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)compoundTag);
            this.setHeldItemStack(postcard);
            this.setRotation(tag.method_10571("ItemRotation"));
        }
        this.method_6892(class_2350.method_10143((int)tag.method_10571("Facing")));
        this.method_5648(tag.method_10577("Invisible"));
        this.fixed = tag.method_10577("Fixed");
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean isEmpty;
        boolean bl = isEmpty = !this.getPostcard().method_7960();
        if (this.fixed) {
            return class_1269.field_5811;
        }
        if (this.method_37908().method_8608()) {
            return isEmpty ? class_1269.field_5812 : class_1269.field_5811;
        }
        if (!isEmpty) {
            this.method_5643(this.method_48923().method_48802(player), 1.0f);
        }
        this.method_5783(this.getRotateItemSound(), 1.0f, 1.0f);
        if (this.method_5735().method_10146() > 1) {
            this.setRotation((this.getRotation() + 1) % 3);
        } else {
            this.setRotation(this.getRotation() + 1);
        }
        return class_1269.field_21466;
    }

    public class_3414 getRotateItemSound() {
        return class_3417.field_15038;
    }

    public class_2596<class_2602> method_18002(class_3231 entity) {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_59940());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.method_6892(class_2350.method_10143((int)packet.method_11166()));
    }

    public class_1799 method_31480() {
        return this.getPostcard();
    }

    public float method_43078() {
        class_2350 direction = this.method_5735();
        int i = direction.method_10166().method_10178() ? 90 * direction.method_10171().method_10181() : 0;
        return class_3532.method_15392((int)(180 + direction.method_10161() * 90 + this.getRotation() * 45 + i));
    }
}

