/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.common.handler;

import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.common.storage.PlayerMailboxData;
import com.flechazo.contact.common.tileentity.MailboxBlockEntity;
import com.flechazo.contact.platform.PlatformHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public final class MailboxManager {
    private static final List<MailToBeSent> READY_TO_REMOVE = Lists.newArrayList();
    private static int updateTick = 0;

    public static void onServerTick(MinecraftServer server) {
        IMailboxDataProvider data = MailboxDataManager.getData(server);
        ++updateTick;
        if ((updateTick %= 20) == 0) {
            for (MailToBeSent mail : data.getMailList()) {
                UUID uuid;
                mail.tick(20);
                if (!mail.isReady() || !data.addMailboxContents(uuid = mail.getUUID(), mail.getContents())) continue;
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.contact.mailbox.new_mail"), false);
                }
                MailboxManager.updateState(uuid, data.data());
                READY_TO_REMOVE.add(mail);
            }
            if (!READY_TO_REMOVE.isEmpty()) {
                data.getMailList().removeAll(READY_TO_REMOVE);
                READY_TO_REMOVE.clear();
            }
        }
    }

    public static void updateState(UUID uuid, PlayerMailboxData data) {
        class_4208 posData = data.getMailboxPos(uuid);
        if (posData != null) {
            MailboxManager.updateState((class_1937)PlatformHelper.getCurrentServer().method_3847(posData.comp_2207()), posData.comp_2208());
        }
    }

    public static void updateState(class_1937 level, class_2338 pos) {
        class_2586 te;
        if (level != null && level.method_22340(pos) && (te = level.method_8321(pos)) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)te).refreshStatus();
        }
    }

    public static int getDeliveryTicks(class_5321<class_1937> fromLevel, class_2338 fromPos, class_5321<class_1937> toLevel, class_2338 toPos) {
        int distance;
        int time = 0;
        if (fromLevel != toLevel) {
            time += ContactCommonConfig.getTicksToAnotherWorld();
        }
        if ((distance = Math.abs(fromPos.method_10263() - toPos.method_10263()) + Math.abs(fromPos.method_10260() - toPos.method_10260())) > 9000) {
            distance = 9000;
        }
        return time += ContactCommonConfig.getPostalSpeed() * distance;
    }

    public static int getDeliveryTicks(class_4208 fromPos, class_4208 toPos) {
        return MailboxManager.getDeliveryTicks((class_5321<class_1937>)fromPos.comp_2207(), fromPos.comp_2208(), (class_5321<class_1937>)toPos.comp_2207(), toPos.comp_2208());
    }
}

