/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.data;

import com.flechazo.contact.Contact;
import com.flechazo.contact.data.PostcardStyle;
import com.flechazo.contact.platform.IDataManagerWrapper;
import com.flechazo.contact.platform.PlatformHelper;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public final class PostcardDataManager {
    private static IDataManagerWrapper<PostcardStyle> manager;

    public static void initialize() {
        manager = PlatformHelper.getPlatformService().getData(PostcardStyle.class);
    }

    public static Map<class_2960, PostcardStyle> getPostcards() {
        if (manager == null) {
            Contact.warn("PostcardDataManager not initialized, returning empty map", new Object[0]);
            return Map.of();
        }
        return manager.getAllData();
    }

    public static PostcardStyle getPostcard(class_2960 id) {
        if (manager == null) {
            Contact.warn("PostcardDataManager not initialized, returning default style", new Object[0]);
            return PostcardStyle.DEFAULT;
        }
        PostcardStyle style = manager.getData(id);
        return style != null ? style : PostcardStyle.DEFAULT;
    }

    public static Set<class_2960> getPostcardIds() {
        return PostcardDataManager.getPostcards().keySet();
    }

    public static boolean hasPostcard(class_2960 id) {
        return PostcardDataManager.getPostcards().containsKey(id);
    }

    public static IDataManagerWrapper<PostcardStyle> getManager() {
        return manager;
    }
}

