/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.network;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.config.ContactCommonConfig;
import com.flechazo.contact.common.handler.AdvancementManager;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.common.storage.IMailboxDataProvider;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.flechazo.contact.network.ActionS2CMessage;
import com.flechazo.contact.network.AddresseeDataMessage;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public record EnquireAddresseeMessage(String nameIn, boolean shouldSend) implements class_8710
{
    public static final class_8710.class_9154<EnquireAddresseeMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"contact", (String)"enquire_addressee_message"));
    public static final class_9139<class_2540, EnquireAddresseeMessage> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, EnquireAddresseeMessage::nameIn, (class_9139)class_9135.field_48547, EnquireAddresseeMessage::shouldSend, EnquireAddresseeMessage::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void handleServer(class_3222 player) {
        if (player == null || this.nameIn.isEmpty()) {
            return;
        }
        IMailboxDataProvider data = MailboxDataManager.getData(player.field_13995);
        String lowerIn = this.nameIn.toLowerCase(Locale.ROOT);
        if (lowerIn.equals("@e") && player.field_13995.method_3835(player.method_7334()) >= 2) {
            this.handleAdminBroadcast(player, data);
            return;
        }
        this.handleNormalEnquiry(player, data, lowerIn);
    }

    private void handleAdminBroadcast(class_3222 player, IMailboxDataProvider data) {
        if (this.shouldSend) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof PostboxScreenHandler) {
                PostboxScreenHandler container = (PostboxScreenHandler)class_17032;
                class_1799 parcel = container.parcel.method_5438(0).method_7972();
                parcel.method_57379((class_9331)ContactDataComponents.POSTCARD_SENDER.get(), (Object)player.method_5477().getString());
                for (UUID uuid : data.getNameToUUID().values()) {
                    data.getMailList().add(new MailToBeSent(uuid, parcel.method_7972(), 0L));
                }
                ActionS2CMessage.create(1).sendTo(player);
                container.parcel.method_5447(0, class_1799.field_8037);
            }
        } else {
            ArrayList<String> names = new ArrayList<String>();
            names.add("@e");
            ArrayList<Integer> ticks = new ArrayList<Integer>();
            ticks.add(0);
            AddresseeDataMessage.create(names, ticks).sendTo(player);
        }
    }

    private void handleNormalEnquiry(class_3222 player, IMailboxDataProvider data, String lowerIn) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : data.getNameToUUID().keySet()) {
            if (name.toLowerCase(Locale.ROOT).startsWith(lowerIn)) {
                names.add(name);
            }
            if (names.size() != 4) continue;
            break;
        }
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        for (String name : names) {
            UUID uuid = data.getNameToUUID().get(name);
            if (data.isMailboxFull(uuid)) {
                ticks.add(-1);
                continue;
            }
            class_4208 mailboxPos = data.getMailboxPos(uuid);
            if (!(player.field_7512 instanceof PostboxScreenHandler)) continue;
            int tick = 0;
            if (!((PostboxScreenHandler)player.field_7512).isEnderMail()) {
                tick = mailboxPos != null ? MailboxManager.getDeliveryTicks((class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), (class_5321<class_1937>)mailboxPos.comp_2207(), mailboxPos.comp_2208()) : (ContactCommonConfig.isEnableCenterMailbox() ? MailboxManager.getDeliveryTicks((class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), (class_5321<class_1937>)class_1937.field_25179, player.method_37908().method_43126()) : -2);
            }
            ticks.add(tick);
        }
        if (player.field_7512 instanceof PostboxScreenHandler) {
            if (this.shouldSend && !names.isEmpty() && Objects.equals(names.getFirst(), this.nameIn) && (Integer)ticks.getFirst() >= 0) {
                this.handleSendMail(player, data, (String)names.getFirst(), (Integer)ticks.getFirst());
            } else {
                AddresseeDataMessage.create(names, ticks).sendTo(player);
            }
        }
    }

    private void handleSendMail(class_3222 player, IMailboxDataProvider data, String recipientName, int deliveryTicks) {
        UUID uuid;
        class_4208 mailboxPos;
        PostboxScreenHandler container = (PostboxScreenHandler)player.field_7512;
        class_1799 parcel = container.parcel.method_5438(0);
        parcel.method_57379((class_9331)ContactDataComponents.POSTCARD_SENDER.get(), (Object)player.method_5477().getString());
        if (IPackageItem.checkAndPostmarkPostcard(parcel, player.method_5477().getString()) || parcel.method_7909() instanceof PostcardItem) {
            AdvancementManager.givePlayerAdvancement(player.field_13995, player, class_2960.method_60654((String)"contact:send_postcard"));
        }
        if ((mailboxPos = data.getMailboxPos(uuid = data.getNameToUUID().get(recipientName))) != null) {
            if (mailboxPos.comp_2207() != player.method_37908().method_27983()) {
                parcel.method_57379((class_9331)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
            }
        } else if (class_1937.field_25179 != player.method_37908().method_27983()) {
            parcel.method_57379((class_9331)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
        }
        data.getMailList().add(new MailToBeSent(uuid, parcel, deliveryTicks));
        ActionS2CMessage.create(1).sendTo(player);
        container.parcel.method_5447(0, class_1799.field_8037);
    }

    public static EnquireAddresseeMessage create(String name, boolean shouldSend) {
        return new EnquireAddresseeMessage(name, shouldSend);
    }

    public void sendToServer() {
        NetworkManager.sendToServer((class_8710)this);
    }
}

