/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.helper.GuiHelper;
import com.flechazo.contact.network.EnquireAddresseeMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PostboxScreen
extends AbstractContainerScreen<PostboxScreenHandler> {
    private static final ResourceLocation RED_TEXTURE = new ResourceLocation("contact", "textures/gui/red_postbox.png");
    private static final ResourceLocation GREEN_TEXTURE = new ResourceLocation("contact", "textures/gui/green_postbox.png");
    private final boolean isRed;
    private int offsetX;
    private int offsetY;
    private IconButton buttonSend;
    private EditBox nameField;
    private int selected = 0;

    public PostboxScreen(PostboxScreenHandler screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.isRed = screenContainer.isRed();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.offsetX = (this.f_96543_ - 176) / 2;
        this.offsetY = (this.f_96544_ - 166) / 2 + 16;
        this.buttonSend = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.offsetX + 97, this.offsetY + 26, 10, 9, (Component)Component.m_237115_((String)"tooltip.contact.postbox.send"), button -> this.send(), this::buttonTooltip));
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.offsetX + 42, this.offsetY + 26, 44, 9, (Component)Component.m_237115_((String)"info.contact.postbox.addressee")));
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94144_(((PostboxScreenHandler)this.f_97732_).playerName);
        this.nameField.m_94151_(this::whileTyping);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(64);
        this.m_264313_((GuiEventListener)this.nameField);
    }

    private void buttonTooltip(Button button, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (button.m_274382_()) {
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, button.m_252754_(), button.m_252907_(), button.m_5711_(), button.m_93694_(), Lists.newArrayList((Object[])new Component[]{button.m_6035_()}));
        }
    }

    private void whileTyping(String name) {
        if (!((PostboxScreenHandler)this.f_97732_).playerName.equals(name)) {
            ((PostboxScreenHandler)this.f_97732_).playerName = name;
            if (((PostboxScreenHandler)this.f_97732_).status == 2) {
                ((PostboxScreenHandler)this.f_97732_).status = 1;
            }
            if (((PostboxScreenHandler)this.f_97732_).status == 1) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.f_97732_).playerName, false);
                packet.sendToServer();
            }
        }
    }

    private void send() {
        if (((PostboxScreenHandler)this.f_97732_).status == 1) {
            if (this.isAddresseeValid() && ((PostboxScreenHandler)this.f_97732_).ticks.get(0) >= 0) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.f_97732_).playerName, true);
                packet.sendToServer();
            }
        } else if (((PostboxScreenHandler)this.f_97732_).status == 2) {
            ((PostboxScreenHandler)this.f_97732_).status = 0;
        }
        this.nameField.m_93692_(false);
    }

    private boolean isAddresseeValid() {
        return !((PostboxScreenHandler)this.f_97732_).names.isEmpty() && Objects.equals(this.nameField.m_94155_(), ((PostboxScreenHandler)this.f_97732_).names.get(0));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nameField.m_94120_();
        if (((PostboxScreenHandler)this.f_97732_).status == 1 && !this.nameField.m_94155_().equals(((PostboxScreenHandler)this.f_97732_).playerName)) {
            this.nameField.m_94144_(((PostboxScreenHandler)this.f_97732_).playerName);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((PostboxScreenHandler)this.f_97732_).status == 1 && this.nameField.m_93696_()) {
            int size = ((PostboxScreenHandler)this.f_97732_).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.f_96547_.m_92895_(((PostboxScreenHandler)this.f_97732_).names.get(i)) + 8, maxWidth);
            }
            if (size != 0 && (double)(this.offsetX + 42) <= mouseX && mouseX < (double)(this.offsetX + 42 + maxWidth) && (double)(this.offsetY + 40 + this.selected * 11) <= mouseY && mouseY < (double)(this.offsetY + 51 + this.selected * 11)) {
                this.nameField.m_94144_(((PostboxScreenHandler)this.f_97732_).names.get(this.selected));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        boolean flag = false;
        if (((PostboxScreenHandler)this.f_97732_).status == 1 && this.nameField.m_93696_()) {
            int size = ((PostboxScreenHandler)this.f_97732_).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.f_96547_.m_92895_(((PostboxScreenHandler)this.f_97732_).names.get(i)) + 8, maxWidth);
            }
            int z = 5000;
            if (size != 0) {
                ResourceLocation texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
                int renderWidth = maxWidth;
                if (renderWidth == 55) {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 55, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 55, 2));
                } else {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 15, 2));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 36, texture, new TexturePos(216, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 39 + 11 * size, texture, new TexturePos(216, 65, 15, 2));
                    renderWidth -= 30;
                    int pos = 0;
                    while (renderWidth > 15) {
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, 15, 3 + 11 * size));
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, 15, 2));
                        renderWidth -= 15;
                        pos += 15;
                    }
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, renderWidth, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, renderWidth, 2));
                }
            }
            for (int i = 0; i < size; ++i) {
                if (this.offsetX + 42 <= mouseX && mouseX < this.offsetX + 42 + maxWidth && this.offsetY + 40 + i * 11 <= mouseY && mouseY < this.offsetY + 51 + i * 11) {
                    this.selected = i;
                    flag = true;
                }
                guiGraphics.m_280056_(this.f_96547_, ((PostboxScreenHandler)this.f_97732_).names.get(i), this.offsetX + 42, this.offsetY + 40 + i * 11, (this.selected == i ? ChatFormatting.YELLOW.m_126665_() : ChatFormatting.WHITE.m_126665_()).intValue(), false);
            }
        }
        guiGraphics.m_280168_().m_85849_();
        if (!flag) {
            this.m_280072_(guiGraphics, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        GuiHelper.drawLayer(guiGraphics.m_280168_(), this.offsetX, this.offsetY, new TexturePos(0, 0, 176, 133));
        GuiHelper.renderButton(guiGraphics, partialTicks, x, y, 0, texture, this.buttonSend, new TexturePos(176, 0, 10, 9), new TexturePos(176, 9, 10, 9));
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"info.contact.postbox.addressee"), 40, 30, 0xE6E6E6, false);
        switch (((PostboxScreenHandler)this.f_97732_).status) {
            case 0: {
                MutableComponent text = Component.m_237115_((String)"info.contact.postbox.need_mail");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 1: {
                if (this.isAddresseeValid()) {
                    int tick = ((PostboxScreenHandler)this.f_97732_).ticks.get(0);
                    if (tick < 0) {
                        MutableComponent text = Component.m_237115_((String)"info.contact.postbox.no_mailbox");
                        this.renderTips(guiGraphics, text);
                        break;
                    }
                    MutableComponent text = Component.m_237115_((String)"info.contact.postbox.estimated");
                    int width = this.f_96547_.m_92895_(text.getString());
                    int min = tick / 1200;
                    int sec = tick % 1200 / 20;
                    if (width > 38) {
                        guiGraphics.m_280614_(this.f_96547_, (Component)text, 141 - width / 2, 26, 0x1A1A1A, false);
                        if (tick < 20) {
                            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"info.contact.postbox.instant"), 141 - width / 2, 38, 0x1A1A1A, false);
                            break;
                        }
                        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 141 - width / 2, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.m_280614_(this.f_96547_, (Component)text, 122, 26, 0x1A1A1A, false);
                    if (tick < 20) {
                        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"info.contact.postbox.instant"), 122, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 122, 38, 0x1A1A1A, false);
                    break;
                }
                MutableComponent text = Component.m_237115_((String)"info.contact.postbox.need_addressee");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 2: {
                MutableComponent text = Component.m_237115_((String)"info.contact.postbox.success");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 3: {
                MutableComponent text = Component.m_237115_((String)"info.contact.postbox.cannot_send");
                this.renderTips(guiGraphics, text);
            }
        }
    }

    private void renderTips(GuiGraphics guiGraphics, MutableComponent text) {
        int width = this.f_96547_.m_92895_(text.getString());
        if (width > 38) {
            List list = this.f_96547_.m_92923_((FormattedText)text, 50);
            for (int i = 0; i < list.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)list.get(i), 118, 38 - list.size() * 6 + i * 12, 0x1A1A1A, false);
            }
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)text, 122, 32, 0x1A1A1A, false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.nameField.m_7933_(keyCode, scanCode, modifiers) || this.nameField.m_93696_() || super.m_7933_(keyCode, scanCode, modifiers);
    }
}

