/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.renderer;

import com.flechazo.contact.client.ClientProxy;
import com.flechazo.contact.common.entity.PostcardEntity;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.helper.ColorHelper;
import com.flechazo.contact.resourse.PostcardStyle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class PostcardEntityRenderer<T extends PostcardEntity>
extends EntityRenderer<T> {
    private static final ModelResourceLocation PIN = new ModelResourceLocation("contact", "postcard_pin", "");
    private static final ModelResourceLocation POSTCARD = new ModelResourceLocation("contact", "postcard", "");
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final List<String> list = Lists.newArrayList();
    private int textHash = 0;

    public PostcardEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.blockRenderDispatcher = ctx.m_234597_();
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        super.m_7392_(entity, yaw, tickDelta, poseStack, multiBufferSource, light);
        poseStack.m_85836_();
        Direction direction = entity.m_6350_();
        Vec3 vec3d = this.getRenderOffset(entity, tickDelta);
        poseStack.m_85837_(-vec3d.m_7096_(), -vec3d.m_7098_(), -vec3d.m_7094_());
        double d = 0.46875;
        poseStack.m_85837_((double)direction.m_122429_() * d, (double)direction.m_122430_() * d, (double)direction.m_122431_() * d);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
        boolean bl = entity.m_20145_();
        ItemStack postcard = ((PostcardEntity)((Object)entity)).getPostcard();
        if (!postcard.m_41619_()) {
            String text;
            PostcardStyle postcardStyle = PostcardStyle.fromNBT(postcard.m_41784_());
            float width = (float)postcardStyle.cardWidth() / 2.0f;
            float height = (float)postcardStyle.cardHeight() / 2.0f;
            int j = ((PostcardEntity)((Object)entity)).getRotation();
            if (direction.m_122411_() > 1) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)((j + 1) % 3 - 1) * 360.0f / 16.0f));
            } else {
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)j * 360.0f / 16.0f));
            }
            ModelManager modelManager = this.blockRenderDispatcher.m_110907_().m_110881_();
            if (!bl && direction.m_122411_() > 1) {
                float red = ColorHelper.getRedF(postcardStyle.postmarkColor());
                float green = ColorHelper.getGreenF(postcardStyle.postmarkColor());
                float blue = ColorHelper.getBlueF(postcardStyle.postmarkColor());
                poseStack.m_85836_();
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                poseStack.m_252880_(0.0f, -(128.0f - height) / 256.0f, 0.0f);
                this.blockRenderDispatcher.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(Sheets.m_110789_()), null, modelManager.m_119422_(PIN), red, green, blue, light, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            poseStack.m_85841_(width / 128.0f, height / 128.0f, 1.0f);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            this.blockRenderDispatcher.m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(Sheets.m_110789_()), null, modelManager.m_119422_(POSTCARD), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_252880_(0.0f, 0.0f, 0.5f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.m_252880_(-64.0f, -64.0f, 0.0f);
            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(ClientProxy.getPostcardCardRenderLayer(postcardStyle));
            float pointX0 = 64.0f - width / 2.0f;
            float pointX1 = 64.0f + width / 2.0f;
            float pointY0 = 64.0f - height / 2.0f;
            float pointY1 = 64.0f + height / 2.0f;
            vertexConsumer.m_252986_(matrix4f, pointX0, pointY1, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_252986_(matrix4f, pointX1, pointY1, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_252986_(matrix4f, pointX1, pointY0, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_252986_(matrix4f, pointX0, pointY0, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            if (postcard.m_41784_().m_128441_("Sender")) {
                float markX0 = pointX0 + (float)postcardStyle.postmarkPosX() / 2.0f;
                float markY0 = pointY0 + (float)postcardStyle.postmarkPosY() / 2.0f;
                VertexConsumer vertex = multiBufferSource.m_6299_(ClientProxy.getPostcardPostmarkRenderLayer(postcardStyle));
                float markWidth = (float)postcardStyle.postmarkWidth() / 2.0f;
                float markHeight = (float)postcardStyle.postmarkHeight() / 2.0f;
                int red = ColorHelper.getRed(postcardStyle.postmarkColor());
                int green = ColorHelper.getGreen(postcardStyle.postmarkColor());
                int blue = ColorHelper.getBlue(postcardStyle.postmarkColor());
                int alpha = ColorHelper.getAlpha(postcardStyle.postmarkColor());
                vertex.m_252986_(matrix4f, markX0, markY0 + markHeight, -0.02f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
                vertex.m_252986_(matrix4f, markX0 + markWidth, markY0 + markHeight, -0.02f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
                vertex.m_252986_(matrix4f, markX0 + markWidth, markY0, -0.02f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
                vertex.m_252986_(matrix4f, markX0, markY0, -0.02f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            }
            if (!(text = PostcardItem.getText(postcard)).isBlank()) {
                Font font = Minecraft.m_91087_().f_91062_;
                float textX0 = pointX0 + (float)postcardStyle.textPosX() / 2.0f;
                float textY0 = pointY0 + (float)postcardStyle.textPosY() / 2.0f;
                if (this.textHash != text.hashCode()) {
                    this.list.clear();
                    font.m_92865_().m_92364_(text, postcardStyle.textWidth(), Style.f_131099_, true, (style, lineStartPos, lineEndPos) -> {
                        String lineTextRaw = text.substring(lineStartPos, lineEndPos);
                        String lineText = StringUtils.stripEnd((String)lineTextRaw, (String)" \n");
                        this.list.add(lineText);
                    });
                    this.textHash = text.hashCode();
                }
                poseStack.m_85836_();
                poseStack.m_252880_(textX0, textY0, -0.025f);
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                poseStack.m_252880_(0.0f, 0.0f, -0.1f);
                for (String t : this.list) {
                    font.m_271703_(t, 0.0f, 0.0f, postcardStyle.textColor(), false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
                    poseStack.m_252880_(0.0f, 12.0f, 0.0f);
                }
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.f_118259_;
    }

    public Vec3 getRenderOffset(T entity, float f) {
        return new Vec3((double)((float)entity.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)entity.m_6350_().m_122431_() * 0.3f));
    }

    protected boolean shouldShowName(T entity) {
        if (!Minecraft.m_91404_() || ((PostcardEntity)((Object)entity)).getPostcard().m_41619_() || !((PostcardEntity)((Object)entity)).getPostcard().m_41788_() || this.f_114476_.f_114359_ != entity) {
            return false;
        }
        double d = this.f_114476_.m_114471_(entity);
        float f = entity.m_20163_() ? 32.0f : 64.0f;
        return d < (double)(f * f);
    }
}

